package com.seatel.mobilehall.ui.home.interactor

import com.android.volley.VolleyError
import com.seatel.mobilehall.ui.home.model.PlanSubscriptionModel
import com.seatel.mobilehall.ui.home.model.YesNumberApiData
import org.json.JSONObject

/**
 *
 *
 * @author Noel
 * @version
 * @created on 18-Oct-18
 */
class BuyYesSimCardInteractor {

    interface OnFinishedListener {
        fun onGetPlanSubscriptionFailed(throwable: VolleyError)
        fun onGetPlanSubscriptionSuccess(data: List<PlanSubscriptionModel>?)
        fun onSearchPhoneNumberFailed(throwable: VolleyError)
        fun onSearchPhoneNumberSuccess(data: YesNumberApiData?)
        fun onSearchMorePhoneNumberFailed(throwable: VolleyError)
        fun onSearchMorePhoneNumberSuccess(data: YesNumberApiData?)
        fun onAddSimToCardFailed(throwable: VolleyError)
        fun onAddSimToCardSuccess(data: JSONObject?)
    }

    interface View {
        fun showWaiting() {}
        fun hideWaiting() {}
        fun showGetPlanSubscriptionFailed(throwable: VolleyError) {}
        fun showGetPlanSubscriptionSuccess(data: List<PlanSubscriptionModel>?) {}
        fun showSearchPhoneNumberFailed(throwable: VolleyError) {}
        fun showSearchPhoneNumberSuccess(data: YesNumberApiData?) {}
        fun showSearchMorePhoneNumberFailed(throwable: VolleyError) {}
        fun showSearchMorePhoneNumberSuccess(data: YesNumberApiData?) {}
        fun showAddSimToCardFailed(throwable: VolleyError) {}
        fun showAddSimToCardSuccess(data: JSONObject?) {}
    }
}