package com.seatel.mobilehall.ui.home.fragment


import android.content.Context
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.adapter.PrefixNumberAdapter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.FirebaseAnalyticsUtil


class PrefixFragment : BaseFragment() {

    private var prefixNumberOneFragment: PrefixNumberOneFragment? = null
    private var isClaimFreeSim: Boolean = false
    private var isWinPromotionFreeSim: Boolean = false
    private var simCardPriceFilter: Int = 0

    fun setIsWinPromotionFreeSim(winPromotion: Boolean) {
        this.isWinPromotionFreeSim = winPromotion
    }

    fun setClaimFreeSim(claimFree: Boolean) {
        this.isClaimFreeSim = claimFree
    }

    fun setSimCardPriceFilter(filter: Int) {
        this.simCardPriceFilter = filter
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setFragmentLayout(R.layout.fragment_prefix)
        FirebaseAnalyticsUtil.getInstance(context).logCustomEvent(Constant.TAB_TOP_UP_PINLESS)
        addFragment()
    }


    private fun addFragment() {
        prefixNumberOneFragment = PrefixNumberOneFragment()
        prefixNumberOneFragment?.click =
            PrefixNumberAdapter.Click { number -> rePlaceFragment(number) }
        val fragmentManager = childFragmentManager
        fragmentManager.beginTransaction().add(R.id.parent_prefix, prefixNumberOneFragment!!)
            .commitAllowingStateLoss()
    }

    private fun rePlaceFragment(number: String) {
        val fragmentManager = childFragmentManager
        val prefixNumberTwoFragment = PrefixNumberTwoFragment.newInstance(number)
        prefixNumberTwoFragment.setClaimFreeSim(isClaimFreeSim)
        prefixNumberTwoFragment.setSimCardPriceFilter(simCardPriceFilter)
        prefixNumberTwoFragment.setIsWinPromotionFreeSim(isWinPromotionFreeSim)
        fragmentManager.beginTransaction().replace(R.id.parent_prefix, prefixNumberTwoFragment)
            .commitAllowingStateLoss()
    }

}
