package com.seatel.mobilehall.ui.home.adapter

import android.animation.ObjectAnimator
import android.content.Context
import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.view.ViewGroup
import android.view.ViewTreeObserver
import android.widget.*
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.ConfirmBuyDataPackActivity
import com.seatel.mobilehall.ui.home.activity.DataPackActivity
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.SeatelUtils


class ValuePackDetailAdapter(
    val mContext: Context, private var mValuePackSectionModel: ValuePackSectionModel,
    private val isShowForFooter: Boolean = false,
    private val isFortunePlan: Boolean = false, private val isFromProduct: Boolean = false
) : BaseAdapter<RecyclerView.ViewHolder>() {

    private val VIEW_TYPE_TITLE = 0
    private val VIEW_TYPE_SUBTITLE = 1
    private val VIEW_TYPE_FORTUNE_PLAN = -1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return if (VIEW_TYPE_TITLE == viewType)
            TitleViewHolder(
                LayoutInflater.from(mContext).inflate(R.layout.item_value_pack_title, parent, false)
            )
        else if (VIEW_TYPE_FORTUNE_PLAN == viewType) {
            FortunePlanHolder(
                LayoutInflater.from(mContext)
                    .inflate(R.layout.item_fortune_pack_detail, parent, false)
            )
        } else
            DetailViewHolder(
                LayoutInflater.from(mContext)
                    .inflate(R.layout.item_value_pack_detail, parent, false)
            )
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        holder.itemView.visibility = View.INVISIBLE
        setAnimations(holder.itemView, position)
        if (holder is TitleViewHolder)
            holder.onBind(mValuePackSectionModel)
        else if (holder is DetailViewHolder && mValuePackSectionModel.valuePackSecTwoModel != null && mValuePackSectionModel.valuePackSecTwoModel.table != null)
            holder.onBind(
                mContext,
                mValuePackSectionModel.valuePackSecTwoModel.table,
                mValuePackSectionModel.valuePackSecThreeModel.description,
                isShowForFooter,
                isFromProduct
            )
        else if ((holder is FortunePlanHolder && mValuePackSectionModel.valuePackSecTwoModel != null && mValuePackSectionModel.valuePackSecTwoModel.table != null))
            holder.onBind(
                mContext,
                mValuePackSectionModel.valuePackSecTwoModel.table,
                mValuePackSectionModel.valuePackSecThreeModel.description,
                isShowForFooter,
                isFromProduct
            )
    }

    override fun getItemViewType(position: Int): Int {

        return if (isShowForFooter) {
            if (isFortunePlan) {
                VIEW_TYPE_FORTUNE_PLAN
            } else {
                VIEW_TYPE_SUBTITLE
            }

        } else {
            if (isFortunePlan) {
                if (position == 0)
                    VIEW_TYPE_TITLE
                else
                    VIEW_TYPE_FORTUNE_PLAN
            } else {
                if (position == 0)
                    VIEW_TYPE_TITLE
                else
                    VIEW_TYPE_SUBTITLE
            }
        }
    }

    fun resetDataNew(data: ValuePackSectionModel) {
        mValuePackSectionModel = data
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return if (isShowForFooter) 1 else 2
    }

    open class TitleViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        private val mTitle: TextView = itemView.findViewById(R.id.value_pack_title)
        private val mSubTitle: TextView = itemView.findViewById(R.id.value_pack_sub_title)


        fun onBind(valuePackSectionModel: ValuePackSectionModel) {
            mTitle.text = valuePackSectionModel.valuePackSecTwoModel.title
            mSubTitle.text = valuePackSectionModel.valuePackSecTwoModel.subTitle

            // mDesc.setText(valuePackSectionModel.getDataPackSecThreeModel().getDescription());

            //            Glide.with(mContext).load(valuePackSectionModel.getDataPackDetailSecOneModel().getMobileImageUrl())
            //                    .fitCenter()
            //                    .crossFade()
            //                    .diskCacheStrategy(DiskCacheStrategy.SOURCE)
            //                    .listener(this)
            //                    .into(mImgDataPack);

        }

//        override fun onException(e: Exception, model: String, target: Target<GlideDrawable>, isFirstResource: Boolean): Boolean {
//            mImgDataPack.visibility = View.GONE
//            return false
//        }
//
//        override fun onResourceReady(resource: GlideDrawable, model: String, target: Target<GlideDrawable>, isFromMemoryCache: Boolean, isFirstResource: Boolean): Boolean {
//            return false
//        }
    }

    open class DetailViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView),
        View.OnClickListener {

        private var viewMainTable: View = itemView.findViewById(R.id.view_main_table)
        private var viewTabLayout: View = itemView.findViewById(R.id.layout_tab)
        private var viewBox: View = itemView.findViewById(R.id.view_box_animate)
        private var viewTabBenefits: View = itemView.findViewById(R.id.layout_tab_benefit)
        private var viewTabTermCondition: View =
            itemView.findViewById(R.id.layout_tab_term_condition)
        private var viewDetailBenefits: View = itemView.findViewById(R.id.layout_benefits)
        private var viewDetailTermCondition: View =
            itemView.findViewById(R.id.layout_term_and_condition)
        private var tvTitleBenefits: TextView = itemView.findViewById(R.id.tv_benefit_title)
        private var tvTitleTerm: TextView = itemView.findViewById(R.id.tv_term_condition_title)
        private var reCyclerViewTerm: RecyclerView =
            itemView.findViewById(R.id.recycler_view_term_and_service)
        private var imgBackgroundTerm: ImageView = itemView.findViewById(R.id.img_bg)
        private var viewTerm: View = itemView.findViewById(R.id.view_term)
        private var btnActivate1: Button = itemView.findViewById(R.id.btn_activate_1)
    //    private var btnActivate2: Button = itemView.findViewById(R.id.btn_activate_2)
        private var btnActivate5: Button = itemView.findViewById(R.id.btn_activate_5)
    //    private var btnActivate8: Button = itemView.findViewById(R.id.btn_activate_8)
        private var tvOriginPrice1: TextView = itemView.findViewById(R.id.tv_dolla_1)
        private var tvOriginPrice2: TextView = itemView.findViewById(R.id.tv_dolla_2)
        private var tvOriginPrice5: TextView = itemView.findViewById(R.id.tv_dolla_3)
    //    private var tvOriginPrice8: TextView = itemView.findViewById(R.id.tv_dolla_4)
        private var tvChangePrice1: TextView = itemView.findViewById(R.id.tv_price_1)
        private var tvChangePrice2: TextView = itemView.findViewById(R.id.tv_price_2)
        private var tvChangePrice5: TextView = itemView.findViewById(R.id.tv_price_3)
    //    private var tvChangePrice8: TextView = itemView.findViewById(R.id.tv_price_4)
        private var tvValidity1: TextView = itemView.findViewById(R.id.tv_validity_1)
        private var tvValidity2: TextView = itemView.findViewById(R.id.tv_validity_2)
        private var tvValidity5: TextView = itemView.findViewById(R.id.tv_validity_3)
    //    private var tvValidity8: TextView = itemView.findViewById(R.id.tv_validity_4)
    //    private var tvActivation1: TextView = itemView.findViewById(R.id.tv_currency_1)
    //    private var tvActivation2: TextView = itemView.findViewById(R.id.tv_currency_2)
    //    private var tvActivation5: TextView = itemView.findViewById(R.id.tv_currency_3)
    //    private var tvActivation8: TextView = itemView.findViewById(R.id.tv_currency_4)
        private var viewActivateButton: LinearLayout =
            itemView.findViewById(R.id.view_activate_button)
        private var mListValuePackTableModel: List<ValuePackTableModel>? = null
        private var lastMove: Float = 0f

        fun onBind(
            context: Context,
            listValuePackTableModel: List<ValuePackTableModel>,
            termAndCondition: String,
            isShowForFooter: Boolean,
            isFromProduct: Boolean
        ) {
            this.mListValuePackTableModel = listValuePackTableModel
            btnActivate1.setOnClickListener(this)
        //    btnActivate2.setOnClickListener(this)
            btnActivate5.setOnClickListener(this)
        //    btnActivate8.setOnClickListener(this)
            viewTabBenefits.setOnClickListener(this)
            viewTabTermCondition.setOnClickListener(this)
            imgBackgroundTerm.setBackgroundColor(Color.WHITE)
            viewTerm.setBackgroundColor(Color.WHITE)
            reCyclerViewTerm.layoutManager = LinearLayoutManager(itemView.context)
            reCyclerViewTerm.adapter = TermAndServiceFooterAdapter(
                itemView.context,
                getTermAndServiceEn(termAndCondition),
                true
            )

            if (SeatelSharePreferences.getInstance(context)
                    ?.getSubPlan() == "Fortune_Plan_Subsplan" || isFromProduct
            ) viewActivateButton.visibility =
                GONE
            else viewActivateButton.visibility = VISIBLE


            setDataTable(listValuePackTableModel)
            if (isShowForFooter) {
                viewTabLayout.visibility = View.GONE
                viewBox.visibility = View.GONE
                viewDetailTermCondition.visibility = View.GONE
                viewMainTable.setBackgroundColor(
                    ContextCompat.getColor(
                        itemView.context,
                        android.R.color.transparent
                    )
                )
                changeBackgorundBox()
            }

            if (itemView.context is DataPackActivity) {
                if ((itemView.context as DataPackActivity).checkIsForPlanAction())
                    changeButtonTitleForPlan()
            }

            viewTabBenefits.viewTreeObserver.addOnGlobalLayoutListener(object :
                ViewTreeObserver.OnGlobalLayoutListener {
                override fun onGlobalLayout() {
                    viewTabBenefits.viewTreeObserver.removeOnGlobalLayoutListener(this)
                    val width = viewTabBenefits.measuredWidth
                    val height = viewTabBenefits.measuredHeight
                    var param: RelativeLayout.LayoutParams =
                        RelativeLayout.LayoutParams(width, height)
                    param.topMargin = 80
                    itemView.findViewById<View>(R.id.view_box_animate).layoutParams = param
                }
            })
        }

        private fun changeButtonTitleForPlan() {
            btnActivate1.text = "Select"
        //    btnActivate2.text = "Select"
            btnActivate5.text = "Select"
        //    btnActivate8.text = "Select"
        }

        private fun changeBackgorundBox() {
            itemView.findViewById<View>(R.id.view_box_price_1).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_price_2).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_price_3).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
       /*     itemView.findViewById<View>(R.id.view_box_price_4).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)*/
            itemView.findViewById<View>(R.id.view_box_exp_1).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_exp_2).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_exp_3).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
           /* itemView.findViewById<View>(R.id.view_box_exp_4).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_sign_1).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_sign_2).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_sign_3).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_sign_4).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)*/
        }

        private fun getBtn(index: Int): Button {
            return when (index) {
                0 -> btnActivate1
              //  1 -> btnActivate2
                else -> btnActivate5
              //  else -> btnActivate8
            }
        }

        private fun setDataTable(listValuePackTableModel: List<ValuePackTableModel>) {
            if (listValuePackTableModel.size > 3) {
                tvOriginPrice1.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[0].valuePrice.toString())}"
                tvOriginPrice2.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[1].valuePrice.toString())}"
                tvOriginPrice5.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[2].valuePrice.toString())}"
                /*tvOriginPrice8.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[3].valuePrice.toString())}"*/

                tvChangePrice1.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[0].priceChange.toString())}"
                tvChangePrice2.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[1].priceChange.toString())}"
                tvChangePrice5.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[2].priceChange.toString())}"
               /* tvChangePrice8.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[3].priceChange.toString())}"*/

                tvValidity1.text = "${listValuePackTableModel[0].validityDate}"
                tvValidity2.text = "${listValuePackTableModel[1].validityDate}"
                tvValidity5.text = "${listValuePackTableModel[2].validityDate}"
                /*tvValidity8.text = "${listValuePackTableModel[3].validityDate}"

                tvActivation1.text = "${listValuePackTableModel[0].activation}"
                tvActivation2.text = "${listValuePackTableModel[1].activation}"
                tvActivation5.text = "${listValuePackTableModel[2].activation}"
                tvActivation8.text = "${listValuePackTableModel[3].activation}"*/

            }
        }

        private fun getTermAndServiceEn(str: String): List<String> {
            val data = ArrayList<String>()
            data.add(str)
            return data
        }

        private fun showConfirmScreen(index: Int) {
            if (mListValuePackTableModel != null && mListValuePackTableModel?.size!! > index) {
                ConfirmBuyDataPackActivity.lunchFromValuePack(
                    itemView.context,
                    mListValuePackTableModel?.get(index)!!,
                    ""
                )
            }
        }

        private fun animateBoxMove(xPos: Float) {
            val transAnimation = ObjectAnimator.ofFloat(
                itemView.findViewById(R.id.view_box_animate),
                "translationX",
                lastMove,
                xPos
            )
            transAnimation.duration = 300//set duration
            transAnimation.start()//start animation
            lastMove = xPos
        }

        override fun onClick(v: View?) {
            if (v != null) {
                when (v.id) {
                    R.id.layout_tab_benefit -> {

                        animateBoxMove(0f)
                        tvTitleBenefits.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorPrimary
                            )
                        )
                        tvTitleTerm.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorTextBlack
                            )
                        )
                        viewDetailBenefits.visibility = View.VISIBLE
                        viewDetailTermCondition.visibility = View.INVISIBLE

//                        ViewCompat.setBackground(viewTabBenefits, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_pink_select))
//                        ViewCompat.setBackground(viewTabTermCondition, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_gray_unselect))
//                        tvTitleBenefits.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorPrimary))
//                        tvTitleTerm.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorTextBlack))
//                        viewDetailBenefits.visibility = View.VISIBLE
//                        viewDetailTermCondition.visibility = View.INVISIBLE
                    }
                    R.id.layout_tab_term_condition -> {
                        animateBoxMove(itemView.findViewById<View>(R.id.view_box_animate).width.toFloat())
                        tvTitleTerm.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorPrimary
                            )
                        )
                        tvTitleBenefits.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorTextBlack
                            )
                        )
                        viewDetailTermCondition.visibility = View.VISIBLE
                        viewDetailBenefits.visibility = View.INVISIBLE

//                        ViewCompat.setBackground(viewTabTermCondition, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_pink_select))
//                        ViewCompat.setBackground(viewTabBenefits, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_gray_unselect))
//                        tvTitleTerm.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorPrimary))
//                        tvTitleBenefits.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorTextBlack))
//                        viewDetailTermCondition.visibility = View.VISIBLE
//                        viewDetailBenefits.visibility = View.INVISIBLE
                    }
                  /*  R.id.btn_activate_1, R.id.btn_activate_2, R.id.btn_activate_5, R.id.btn_activate_8 -> {
                        val index = v.tag.toString().toInt()
                        if (mListValuePackTableModel != null) {
                            if (itemView.context is DataPackActivity) {
                                if ((itemView.context as DataPackActivity).checkIsForPlanAction()) {
                                    val priceChange =
                                        mListValuePackTableModel?.get(index)!!.priceChange.replace(
                                            "$",
                                            ""
                                        ).trim()
                                    val priceOrigin =
                                        mListValuePackTableModel?.get(index)!!.valuePrice.replace(
                                            "$",
                                            ""
                                        ).trim()
                                    (itemView.context as DataPackActivity).setDataValuePackResultForPlanSelect(
                                        priceOrigin,
                                        priceChange.toInt()
                                    )
                                } else showConfirmScreen(index)
                            } else {
                                showConfirmScreen(index)
                            }
                        }

                    }*/
                }
            }
        }
    }

    open class FortunePlanHolder(itemView: View) : RecyclerView.ViewHolder(itemView),
        View.OnClickListener {

        private var viewMainTable: View = itemView.findViewById(R.id.view_main_table)
        private var viewTabLayout: View = itemView.findViewById(R.id.layout_tab)
        private var viewBox: View = itemView.findViewById(R.id.view_box_animate)
        private var viewTabBenefits: View = itemView.findViewById(R.id.layout_tab_benefit)
        private var viewTabTermCondition: View =
            itemView.findViewById(R.id.layout_tab_term_condition)
        private var viewDetailBenefits: View = itemView.findViewById(R.id.layout_benefits)
        private var viewDetailTermCondition: View =
            itemView.findViewById(R.id.layout_term_and_condition)
        private var tvTitleBenefits: TextView = itemView.findViewById(R.id.tv_benefit_title)
        private var tvTitleTerm: TextView = itemView.findViewById(R.id.tv_term_condition_title)
        private var reCyclerViewTerm: RecyclerView =
            itemView.findViewById(R.id.recycler_view_term_and_service)
        private var imgBackgroundTerm: ImageView = itemView.findViewById(R.id.img_bg)
        private var viewTerm: View = itemView.findViewById(R.id.view_term)
        private var btnActivate1: Button = itemView.findViewById(R.id.btn_activate_1)
        private var btnActivate5: Button = itemView.findViewById(R.id.btn_activate_5)
        private var btnActivate10: Button = itemView.findViewById(R.id.btn_activate_10)
        private var viewActivateButton: LinearLayout =
            itemView.findViewById(R.id.view_activate_button)


        private var tvOriginPrice1: TextView = itemView.findViewById(R.id.tv_dolla_1)
        private var tvOriginPrice5: TextView = itemView.findViewById(R.id.tv_dolla_2)
        private var tvOriginPrice10: TextView = itemView.findViewById(R.id.tv_dolla_3)

        private var tvChangePrice1: TextView = itemView.findViewById(R.id.tv_price_1)
        private var tvChangePrice5: TextView = itemView.findViewById(R.id.tv_price_2)
        private var tvChangePrice10: TextView = itemView.findViewById(R.id.tv_price_3)

        private var tvValidity1: TextView = itemView.findViewById(R.id.tv_validity_1)
        private var tvValidity5: TextView = itemView.findViewById(R.id.tv_validity_2)
        private var tvValidity10: TextView = itemView.findViewById(R.id.tv_validity_3)

        private var mListValuePackTableModel: List<ValuePackTableModel>? = null
        private var lastMove: Float = 0f

        fun onBind(
            context: Context,
            listValuePackTableModel: List<ValuePackTableModel>,
            termAndCondition: String,
            isShowForFooter: Boolean,
            isFromProduct: Boolean
        ) {
            this.mListValuePackTableModel = listValuePackTableModel
            btnActivate1.setOnClickListener(this)
            btnActivate5.setOnClickListener(this)
            btnActivate10.setOnClickListener(this)

            viewTabBenefits.setOnClickListener(this)
            viewTabTermCondition.setOnClickListener(this)
            imgBackgroundTerm.setBackgroundColor(Color.WHITE)
            viewTerm.setBackgroundColor(Color.WHITE)
            reCyclerViewTerm.layoutManager = LinearLayoutManager(itemView.context)
            reCyclerViewTerm.adapter = TermAndServiceFooterAdapter(
                itemView.context,
                getTermAndServiceEn(termAndCondition),
                true
            )
            if (SeatelSharePreferences.getInstance(context)
                    ?.isHasInstalmentPlan()!! || SeatelSharePreferences.getInstance(
                    context
                )?.getSubPlan() != "Fortune_Plan_Subsplan" || isFromProduct
            )
                viewActivateButton.visibility = GONE
            else
                viewActivateButton.visibility = VISIBLE

            setDataTable(listValuePackTableModel)
            if (isShowForFooter) {
                viewTabLayout.visibility = View.GONE
                viewBox.visibility = View.GONE
                viewDetailTermCondition.visibility = View.GONE
                viewMainTable.setBackgroundColor(
                    ContextCompat.getColor(
                        itemView.context,
                        android.R.color.transparent
                    )
                )
                changeBackgorundBox()
            }

            if (itemView.context is DataPackActivity) {
                if ((itemView.context as DataPackActivity).checkIsForPlanAction())
                    changeButtonTitleForPlan()
            }

            viewTabBenefits.viewTreeObserver.addOnGlobalLayoutListener(object :
                ViewTreeObserver.OnGlobalLayoutListener {
                override fun onGlobalLayout() {
                    viewTabBenefits.viewTreeObserver.removeOnGlobalLayoutListener(this)
                    val width = viewTabBenefits.measuredWidth
                    val height = viewTabBenefits.measuredHeight
                    var param: RelativeLayout.LayoutParams =
                        RelativeLayout.LayoutParams(width, height)
                    param.topMargin = 80
                    itemView.findViewById<View>(R.id.view_box_animate).layoutParams = param
                }
            })
        }

        private fun changeButtonTitleForPlan() {
            btnActivate1.text = "Select"
            btnActivate5.text = "Select"
            btnActivate10.text = "Select"
        }

        private fun changeBackgorundBox() {
            itemView.findViewById<View>(R.id.view_box_price_1).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_price_2).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_price_3).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_exp_1).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_exp_2).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)
            itemView.findViewById<View>(R.id.view_box_exp_3).background =
                ContextCompat.getDrawable(itemView.context, R.drawable.bg_white_box_round)

        }

        private fun getBtn(index: Int): Button {
            return when (index) {
                0 -> btnActivate1
                1 -> btnActivate5
                else -> btnActivate10
            }
        }

        private fun setDataTable(listValuePackTableModel: List<ValuePackTableModel>) {
            if (listValuePackTableModel.size > 3) {
                tvOriginPrice1.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[0].valuePrice.toString())}"
                tvOriginPrice5.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[1].valuePrice.toString())}"
                tvOriginPrice10.text =
                    "${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[2].valuePrice.toString())}"

                tvChangePrice1.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[0].priceChange.toString())}"
                tvChangePrice5.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[1].priceChange.toString())}"
                tvChangePrice10.text =
                    "=${SeatelUtils.displayAmountNoDecial(listValuePackTableModel[2].priceChange.toString())}"

                tvValidity1.text = "${listValuePackTableModel[0].validityDate}"
                tvValidity5.text = "${listValuePackTableModel[1].validityDate}"
                tvValidity10.text = "${listValuePackTableModel[2].validityDate}"

                /*  tvActivation1.text = "${listValuePackTableModel[0].activation}"
                  tvActivation5.text = "${listValuePackTableModel[1].activation}"
                  tvActivation10.text = "${listValuePackTableModel[2].activation}"*/

            }
        }

        private fun getTermAndServiceEn(str: String): List<String> {
            val data = ArrayList<String>()
            data.add(str)
            return data
        }

        private fun showConfirmScreen(index: Int) {
            if (mListValuePackTableModel != null && mListValuePackTableModel?.size!! > index) {
                ConfirmBuyDataPackActivity.lunchFromValuePack(
                    itemView.context,
                    mListValuePackTableModel?.get(index)!!,
                    ""
                )
            }
        }

        private fun animateBoxMove(xPos: Float) {
            val transAnimation = ObjectAnimator.ofFloat(
                itemView.findViewById(R.id.view_box_animate),
                "translationX",
                lastMove,
                xPos
            )
            transAnimation.duration = 300//set duration
            transAnimation.start()//start animation
            lastMove = xPos
        }

        override fun onClick(v: View?) {
            if (v != null) {
                when (v.id) {
                    R.id.layout_tab_benefit -> {

                        animateBoxMove(0f)
                        tvTitleBenefits.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorPrimary
                            )
                        )
                        tvTitleTerm.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorTextBlack
                            )
                        )
                        viewDetailBenefits.visibility = View.VISIBLE
                        viewDetailTermCondition.visibility = View.INVISIBLE

//                        ViewCompat.setBackground(viewTabBenefits, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_pink_select))
//                        ViewCompat.setBackground(viewTabTermCondition, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_gray_unselect))
//                        tvTitleBenefits.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorPrimary))
//                        tvTitleTerm.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorTextBlack))
//                        viewDetailBenefits.visibility = View.VISIBLE
//                        viewDetailTermCondition.visibility = View.INVISIBLE
                    }
                    R.id.layout_tab_term_condition -> {
                        animateBoxMove(itemView.findViewById<View>(R.id.view_box_animate).width.toFloat())
                        tvTitleTerm.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorPrimary
                            )
                        )
                        tvTitleBenefits.setTextColor(
                            ContextCompat.getColor(
                                itemView.context,
                                R.color.colorTextBlack
                            )
                        )
                        viewDetailTermCondition.visibility = View.VISIBLE
                        viewDetailBenefits.visibility = View.INVISIBLE

//                        ViewCompat.setBackground(viewTabTermCondition, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_pink_select))
//                        ViewCompat.setBackground(viewTabBenefits, ContextCompat.getDrawable(itemView.context, R.drawable.bg_tab_value_pack_round_gray_unselect))
//                        tvTitleTerm.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorPrimary))
//                        tvTitleBenefits.setTextColor(ContextCompat.getColor(itemView.context, R.color.colorTextBlack))
//                        viewDetailTermCondition.visibility = View.VISIBLE
//                        viewDetailBenefits.visibility = View.INVISIBLE
                    }
                    R.id.btn_activate_1, R.id.btn_activate_5, R.id.btn_activate_10 -> {
                        val index = v.tag.toString().toInt()
                        if (mListValuePackTableModel != null) {
                            if (itemView.context is DataPackActivity) {
                                if ((itemView.context as DataPackActivity).checkIsForPlanAction()) {
                                    val priceChange =
                                        mListValuePackTableModel?.get(index)!!.priceChange.replace(
                                            "$",
                                            ""
                                        ).trim()
                                    val priceOrigin =
                                        mListValuePackTableModel?.get(index)!!.valuePrice.replace(
                                            "$",
                                            ""
                                        ).trim()
                                    (itemView.context as DataPackActivity).setDataValuePackResultForPlanSelect(
                                        priceOrigin,
                                        priceChange.toInt()
                                    )
                                } else {
                                    if (mListValuePackTableModel != null && mListValuePackTableModel?.size!! > index) {
                                        ConfirmBuyDataPackActivity.lunchFromValuePack(
                                            itemView.context,
                                            mListValuePackTableModel?.get(index)!!,
                                            "",
                                            isFortunePlan = true
                                        )
                                    }
                                }
                            } else {
                                if (mListValuePackTableModel != null && mListValuePackTableModel?.size!! > index) {
                                    ConfirmBuyDataPackActivity.lunchFromValuePack(
                                        itemView.context,
                                        mListValuePackTableModel?.get(index)!!,
                                        "",
                                        isFortunePlan = true
                                    )
                                }
                            }
                        }

                    }
                }
            }
        }
    }

}
