package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.google.gson.Gson
import com.seatel.mobilehall.databinding.ItemShopLocationBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.ContactUsActivity
import com.seatel.mobilehall.ui.home.activity.LocationShopMapActivity
import com.seatel.mobilehall.ui.home.interactor.LocationShopMapInteractor
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.SeatelUtils

class ShopLocationAdapter(
    private var items: ArrayList<SeatelShopLocationModel>,
    private val context: Context
) : BaseAdapter<ShopLocationAdapter.ViewHolder>() {

    private var isShowOnlyLocalArea = false
    private lateinit var mLocationInterator: LocationShopMapInteractor

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = ItemShopLocationBinding.inflate(LayoutInflater.from(context), parent, false)
        return ViewHolder(binding)
    }

    fun setClickLocalAreaSearch(onstartSearch: LocationShopMapInteractor) {
        this.mLocationInterator = onstartSearch
    }

    fun removeAll() {
        items = ArrayList<SeatelShopLocationModel>()
        notifyDataSetChanged()
    }

    fun updatedDataLocation(item: ArrayList<SeatelShopLocationModel>, showName: Boolean) {
        this.items.addAll(item)
        this.isShowOnlyLocalArea = showName
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int = items.size

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bindView(items[position], isShowOnlyLocalArea)

        holder.itemView.setOnClickListener {
            if (isShowOnlyLocalArea) {
                mLocationInterator.onStartSearch(items[position].localArea)
            } else {
                ContactUsActivity.lunch(context, Gson().toJson(items[position]))
            }
        }

        if (isShowOnlyLocalArea) {
            holder.binding.btnDirection.visibility = View.GONE

            holder.binding.tvPhone.visibility = View.GONE
            holder.binding.tvTitle.visibility = View.GONE
            holder.binding.imgCall.visibility = View.GONE
        } else {
            holder.binding.btnDirection.visibility = View.VISIBLE
            holder.binding.tvPhone.visibility = View.VISIBLE
            holder.binding.tvTitle.visibility = View.VISIBLE
            holder.binding.imgCall.visibility = View.VISIBLE
        }

        holder.binding.btnDirection.setOnClickListener {
            val intent = Intent(
                android.content.Intent.ACTION_VIEW,
                Uri.parse("http://maps.google.com/maps?daddr=${items[position].latitude},${items[position].longitude}")
            )
            context.startActivity(intent)
        }

        holder.binding.phoneCall.setOnClickListener {
            (context as LocationShopMapActivity).showCallDialog(items[position].contactNumber)
        }
    }

    class ViewHolder(val binding: ItemShopLocationBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bindView(rowData: SeatelShopLocationModel, showLocalArea: Boolean) {
            binding.tvTitle.text = rowData.name
            if (showLocalArea) {
                binding.tvAddress.text = rowData.localArea
            } else {
                binding.tvAddress.text = rowData.address
            }
            binding.tvPhone.text = SeatelUtils.getPhoneFormatWithOutCode(rowData.contactNumber)
        }
    }
}
