package com.seatel.mobilehall.ui.home.adapter

import android.app.Activity
import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.FaqDetailActivity
import com.seatel.mobilehall.ui.home.model.FAQModel
import com.seatel.mobilehall.databinding.RelatedQuestionListItemBinding

class RelatedQuestionListAdapter(
    private val context: Context,
    private var relatedQuestions: List<FAQModel>
) : BaseAdapter<RelatedQuestionListAdapter.RelatedQuestionVH>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RelatedQuestionVH {
        val binding = RelatedQuestionListItemBinding.inflate(LayoutInflater.from(context), parent, false)
        return RelatedQuestionVH(binding)
    }

    override fun getItemCount(): Int = relatedQuestions.size

    override fun onBindViewHolder(holder: RelatedQuestionVH, position: Int) {
        val question = relatedQuestions[position]
        holder.bind(question)

        holder.itemView.setOnClickListener {
            if (context is Activity) {
                context.finish()
            }

            val faqId = question.id
            val questionText = question.question

            if (faqId != null && questionText != null) {
                FaqDetailActivity.lunch(context, faqId, questionText)
            }
        }
    }

    class RelatedQuestionVH(private val binding: RelatedQuestionListItemBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(faqModel: FAQModel) {
            // Bind data to the views using ViewBinding
            binding.textDescription.text = faqModel.question
        }
    }
}
