import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel


class
ProductServiceAdapter(
    private val mContext: Context,
    private val productServiceModels: List<AppProductsResponseModel>,
    private val rowClick: (index: AppProductsResponseModel) -> Unit
) : BaseAdapter<ProductServiceAdapter.ProductServiceViewHolder>() {

    //    private var lastPosition = -1
    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): ProductServiceViewHolder {
        return ProductServiceViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_products_service, parent, false)
        )
    }

    override fun onBindViewHolder(
        holder: ProductServiceViewHolder,
        position: Int
    ) {
        setAnimations(holder.itemView, position)
        //  holder.itemView.visibility = View.INVISIBLE
        val serviceModel = productServiceModels[position]
        holder.textProductServiceName.text = serviceModel.name
        Glide.with(mContext).load(serviceModel.icon).into(holder.imageResource)
        holder.itemView.setOnClickListener {
            serviceModel.let(rowClick)
//               serviceModel.code?.let { it1 -> rowClick(it1) }

        }
    }

    override fun getItemCount(): Int {
        return productServiceModels.size
    }

    class ProductServiceViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val textProductServiceName: TextView =
            itemView.findViewById(R.id.text_products_service_name)
        val imageResource: ImageView = itemView.findViewById(R.id.img1)
    }
}


