package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.seatel.mobilehall.R;

import java.util.ArrayList;

public class PrefixNumberAdapter extends RecyclerView.Adapter<PrefixNumberAdapter.PrefixNumberViewHolder> {

    public Click getClick() {
        return click;
    }

    public void setClick(Click click) {
        this.click = click;
    }

    private Click click;
    private final Context mContext;
    private final ArrayList<PrefixNumberModel> mPrefixNumberModels;

    public PrefixNumberAdapter(Context mContext, ArrayList<PrefixNumberModel> mPrefixNumberModels) {
        this.mContext = mContext;
        this.mPrefixNumberModels = mPrefixNumberModels;
    }

    @NonNull
    @Override
    public PrefixNumberViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new PrefixNumberViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_prefix_number, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull PrefixNumberViewHolder holder, int position) {
        final PrefixNumberModel prefixNumberModel = mPrefixNumberModels.get(position);
        holder.prifixNumber.setText(prefixNumberModel.getNumber());
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (click != null) {
                    click.onClick(prefixNumberModel.number);
                }
            }
        });

    }

    @Override
    public int getItemCount() {
        return mPrefixNumberModels.size();
    }

    class PrefixNumberViewHolder extends RecyclerView.ViewHolder {
        private final TextView prifixNumber;

        PrefixNumberViewHolder(View itemView) {
            super(itemView);
            prifixNumber = itemView.findViewById(R.id.text_view_prefix_number);
        }
    }


    //Model Prefix Number
    public static class PrefixNumberModel {
        private String number;

        public PrefixNumberModel(String number) {
            this.number = number;
        }

        public String getNumber() {
            return number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    public interface Click {
        void onClick(String number);
    }
}
