package com.seatel.mobilehall.ui.home.adapter

import android.annotation.SuppressLint
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.MyOrderActivity
import com.seatel.mobilehall.ui.home.interactor.NotificationListInteractor
import com.seatel.mobilehall.ui.home.model.NotificationModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import java.text.ParseException


class NotificationAdapter(
    private var mNotification: ArrayList<NotificationModel>,
    private val mContext: Context, private val mView: NotificationListInteractor.View
) :
    BaseAdapter<NotificationAdapter.NotificationViewHolder>() {

    private var isAll: Boolean? = false
    private var isLoaded: Boolean? = true

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): NotificationViewHolder {
        return NotificationViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_notification_holder, parent, false)
        )
    }

    fun clearData() {
        mNotification = ArrayList()
    }

    fun addItems(dataItem: ArrayList<NotificationModel>) {
        mNotification.addAll(dataItem)
        if (dataItem.size == 0) {
            notifyDataSetChanged()
        }
        isAll = dataItem.size == 0
        notifyDataSetChanged()
        notifyItemRangeChanged(itemCount, mNotification.size)
        setLoaded(false)
    }

    fun setLoaded(loaded: Boolean?) {
        isLoaded = loaded
    }

    fun onScrollEvent(linearLayoutManager: LinearLayoutManager) {

        val lastChild = linearLayoutManager.findLastVisibleItemPosition()
        if (lastChild + 1 >= itemCount - 1 && !isLoaded!! && !isAll!!) {
            mView.onLoadMore()
            isLoaded = true
        }
    }

    @SuppressLint("SimpleDateFormat")
    override fun onBindViewHolder(holder: NotificationViewHolder, position: Int) {
//        if (getLastPosition() == -1) {
//            holder.itemView.visibility = View.INVISIBLE
//        }
//        setAnimation(holder.itemView, position)

        val notificationModel = mNotification[position]
//        holder.time.text = notificationModel.
        holder.title.text = notificationModel.title
        holder.messages.text = notificationModel.message
        holder.data.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'",
            Constant.DATE_FORMAT_DISPLAY,
            notificationModel.createdAt
        )

        try {
            var strTime = SeatelUtils.getDateTime(
                "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'",
                "hh:mm a", notificationModel.createdAt
            ).replace("AM", "am")
                .replace("PM", "pm")
            holder.time.text = strTime
        } catch (e: ParseException) {
            e.printStackTrace()
        }


        if (notificationModel.hasSeen) {
            holder.itemView.setBackgroundColor(
                ContextCompat.getColor(
                    mContext,
                    android.R.color.white
                )
            )
        } else {
            holder.itemView.setBackgroundColor(
                ContextCompat.getColor(
                    mContext,
                    R.color.colorRowUnseen
                )
            )
        }
        holder.itemView.setOnClickListener {
            when (notificationModel.typeRow) {
                //  Constant.NotificationType.TOP_UP -> { MySubscriptionsActivity.lunch(mContext)}
                Constant.ORDER -> {
                    MyOrderActivity.lunch(mContext)
                }
            }
        }
    }

    override fun getItemCount(): Int {
        return mNotification.size
    }

    class NotificationViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val time: TextView = itemView.findViewById(R.id.time_notification)
        val messages: TextView = itemView.findViewById(R.id.text_view_notification)
        val title: TextView = itemView.findViewById(R.id.text_view_notification_title)
        val data: TextView = itemView.findViewById(R.id.text_view_date_notification)
        val logo: ImageView = itemView.findViewById(R.id.image_view_notification)

    }
}
