package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.SupportListItemBinding
import com.seatel.mobilehall.ui.home.activity.FaqDetailActivity
import com.seatel.mobilehall.ui.home.model.FAQModel

class FAQsAdapter(var context: Context, var faqList: List<FAQModel>) :
    RecyclerView.Adapter<FAQsAdapter.FAQVH>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): FAQVH {
        // Use ViewBinding to inflate the layout
        val binding = SupportListItemBinding.inflate(LayoutInflater.from(context), parent, false)
        return FAQVH(binding)
    }

    override fun getItemCount(): Int {
        return faqList.size
    }

    override fun onBindViewHolder(holder: FAQVH, position: Int) {
        val faqItem = faqList[position]
        holder.bind(faqItem)

        // Handle click event
        holder.itemView.setOnClickListener {
            FaqDetailActivity.lunch(
                context,
                faqItem.id!!,
                faqItem.question!!
            )
        }
    }

    // ViewHolder using View Binding
    class FAQVH(private val binding: SupportListItemBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(faqItem: FAQModel) {
            // Bind data to the views using ViewBinding
            binding.textDescription.text = faqItem.question
        }
    }
}
