package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.activity.MyCartActivity
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.PlanSubscriptionRequestModel
import java.util.*

open class AddOnsAdapter(
    private val mContext: Context,
    private val myAddonsModels: List<PlanSubscriptionRequestModel.AddOns>,
    private val notifyRow: MyCartAddOnClick? = null,
    private val rowPosition: Int? = null
) :
    RecyclerView.Adapter<AddOnsAdapter.ViewHolderDevice>() {

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): ViewHolderDevice {
        return ViewHolderDevice(
            LayoutInflater.from(mContext).inflate(R.layout.item_order_sim_card, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ViewHolderDevice, position: Int) {
        holder.bind(mContext, myAddonsModels[position])
        if (mContext is MyCartActivity)
            holder.itemView.setOnClickListener {
                if (notifyRow != null && rowPosition != null)
                    notifyRow.rowClickNotify(rowPosition)
            }
    }

    override fun getItemCount(): Int {
        return myAddonsModels.size
    }

    class ViewHolderDevice(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private val orderRowName: TextView = itemView.findViewById(R.id.title_add_ons)
        private val orderDes: TextView = itemView.findViewById(R.id.ctv_add_ons)
        private val orderPrice: TextView = itemView.findViewById(R.id.ctv_add_ons_price)
        private val imgResource: ImageView = itemView.findViewById(R.id.image_view_plan)
        private var dayStr = SeatelUtils.translatForDialog(itemView.context, "Day")

        fun bind(context: Context, myAddonModel: PlanSubscriptionRequestModel.AddOns) {
            orderRowName.text = SeatelUtils.toCamelCase("Add on")
            var addOnName = myAddonModel.addOnName
            if (myAddonModel.amount!! > 0.0) {
                addOnName = SeatelUtils.translatForDialog(context, addOnName)
                var str = "$addOnName (${
                    checkDayStr(
                        dayStr,
                        myAddonModel.duration
                    )
                } = ${SeatelUtils.formatDecimalNumber(myAddonModel.amount!!, "$#.##")})"
                if (myAddonModel.addOnName?.lowercase(Locale.getDefault()) == "value pack")
                    str = "$addOnName (${
                        SeatelUtils.formatDecimalNumber(
                            myAddonModel.amount!!,
                            "$#.#"
                        )
                    } = ${
                        SeatelUtils.formatDecimalNumber(
                            myAddonModel.duration.toDouble(),
                            "$###,###"
                        )
                    })"
                addOnName = str
            }
            orderDes.text = addOnName
            orderPrice.text = ""
            if (myAddonModel.addOnIcon!!.isNotEmpty())
                Glide.with(context).load(myAddonModel.addOnIcon).into(imgResource)
        }

        private fun checkDayStr(strDay: String, dayCount: Int): String {
            return when (SeatelUtils.getLangaugeCode(itemView.context)) {
                Constant.KHMER, Constant.CHINESE -> {
                    "$dayCount$strDay"
                }
                else -> {
                    "$dayCount-$strDay"
                }
            }
        }

    }

    interface MyCartAddOnClick {
        fun rowClickNotify(position: Int)
    }
}
