package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivitySupportBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.SupportAdapter
import com.seatel.mobilehall.ui.home.interactor.ItemViewInteractor
import com.seatel.mobilehall.util.Constant

class SupportActivity : BaseActivity<ActivitySupportBinding>(), ItemViewInteractor {

    override fun onClick(view: View, position: Int) {
        if (position == 0) {
            SupportListActivity.lunch(this, false, Constant.EXTRA_FAQ, ArrayList())
        } else
            SupportListActivity.lunch(
                this,
                false,
                Constant.EXTRA_SUPPORTED_DEVICE,
                ArrayList()
            )
    }

    override fun getViewBinding(): ActivitySupportBinding {
        return ActivitySupportBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    //    setContentView(R.layout.activity_support)
        activityEnterRightAnimation()

        val supportAdapter = SupportAdapter(this, this)

        binding.rvSupport.layoutManager = LinearLayoutManager(this)
        binding.rvSupport.adapter = supportAdapter

    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun isDisplayToolbar(): Boolean {
        return true
    }

    override fun getToolbarTitle(): String {
        return getString(R.string.support)
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, SupportActivity::class.java)
            context.startActivity(intent)
        }
    }
}
