package com.seatel.mobilehall.ui.application

import android.content.Context
import android.os.StrictMode
import androidx.multidex.MultiDex
import androidx.multidex.MultiDexApplication
import com.facebook.drawee.backends.pipeline.Fresco
import io.realm.Realm
import io.realm.RealmConfiguration


class MyApplication : MultiDexApplication() {


    private lateinit var realmConfiguration: RealmConfiguration

    override fun onCreate() {
        super.onCreate()
        MyApplication.appContext = applicationContext
        Realm.init(this)
        Fresco.initialize(this)
        val builder = StrictMode.VmPolicy.Builder()
        StrictMode.setVmPolicy(builder.build())
    }

    //Clear Realm Table
    private fun initRealm() {

        realmConfiguration = RealmConfiguration.Builder()
            .deleteRealmIfMigrationNeeded()
            .build()

        Realm.setDefaultConfiguration(realmConfiguration)
    }


    companion object {

        /**
         * isInternetConnected default value is true becuz don't wan't to show snackbar when app open
         * with internet have connected
         */
        var isInternetConnected = true

        var isUpdatedLangauge = false

        var isFirstInstall = false

        var isPushTokenRegister = -1

        var isAddnewNumberDone = false

        var badgeCartCount = 0

        var isUnlimitedInternet = false

        var flagAppResume = false

        var flagAppResumeFirst = -1

        var appRunning = false

        lateinit var appContext: Context
    }

    override fun attachBaseContext(base: Context?) {
        super.attachBaseContext(base)
        MultiDex.install(this)
    }
}