package com.seatel.mobilehall.data.prefs

import android.content.Context
import android.content.SharedPreferences

class LanguagePreference(context: Context) {

    private var sharedPref: SharedPreferences? = null

    init {
        this.sharedPref = context.getSharedPreferences("SeatelLanguage", Context.MODE_PRIVATE)
    }

    companion object {
        @Volatile
        private var instance: LanguagePreference? = null

        fun getInstance(context: Context): LanguagePreference? {
            if (instance == null)  // NOT thread safe!
                instance = LanguagePreference(context)
            return instance
        }
    }


    fun getAppSharedLanguageCodePreference(): String? {
        return sharedPref?.getString("LANGUAGE_CODE", "")
    }

    fun setAppSharedLanguageCodePreference(languageCode: String) {
        sharedPref?.edit()?.putString("LANGUAGE_CODE", languageCode)?.apply()
    }

    fun setLanguageVersion(languageVersion: String?) {
        sharedPref?.edit()?.putString("LANGUAGES_VERSION", languageVersion)?.apply()
    }

    fun getLanguageVersion(): String? {
        return sharedPref?.getString("LANGUAGES_VERSION", "")
    }

    fun getAppSharedLanguagePreference(): String? {
        return sharedPref?.getString("LANGUAGE", "")
    }

    fun setAppSharedLanguagePreference(languages: String) {
        sharedPref?.edit()?.putString("LANGUAGE", languages)?.apply()
    }



}