package com.seatel.mobilehall.util.customview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.seatel.mobilehall.R;


public class ErrorHandleView extends FrameLayout {

    private ProgressBar progressBar;
    private ImageView icon;
    private ImageView retry;
    private TextView smg;
    private String mErrorMessage = getContext().getString(R.string.no_data);
    private String mErrorNotification = getContext().getString(R.string.no_notification);

    public enum Mode {
        NO_INTERNET,
        LOADING,
        NO_DATA,
        TIME_OUT,
        NO_NOTIFICATION
    }

    public ErrorHandleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    public ErrorHandleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public ErrorHandleView(Context context) {
        super(context);
        initView();
    }

    private void initView() {
        LayoutInflater.from(getContext()).inflate(R.layout.view_error_handler, this);
        setVisibility(INVISIBLE);
        progressBar = findViewById(R.id.progress);
        smg = findViewById(R.id.text_msg);
        icon = findViewById(R.id.image_icon);
        retry = findViewById(R.id.image_retry);
    }

    public void setViewMode(Mode mode) {
        setVisibility(VISIBLE);
        switch (mode) {
            case LOADING:
                progressBar.setVisibility(VISIBLE);
                findViewById(R.id.no_internet_view).setVisibility(INVISIBLE);
                smg.setText("");
                break;
            case NO_DATA:
                progressBar.setVisibility(GONE);
                findViewById(R.id.no_internet_view).setVisibility(VISIBLE);
                smg.setText(getErrorMessage());
                icon.setImageResource(R.drawable.ic_default_logo);
                break;
            case NO_NOTIFICATION:
                progressBar.setVisibility(GONE);
                findViewById(R.id.no_internet_view).setVisibility(VISIBLE);
                smg.setText(getErrorNotification());
                icon.setImageResource(R.drawable.ic_default_logo);
                break;
            case TIME_OUT:
                progressBar.setVisibility(GONE);
                findViewById(R.id.no_internet_view).setVisibility(VISIBLE);
                icon.setImageResource(R.drawable.ic_default_logo);
                smg.setText(getErrorMessage());
                break;
            default:
                progressBar.setVisibility(GONE);
                findViewById(R.id.no_internet_view).setVisibility(VISIBLE);
                icon.setImageResource(R.drawable.ic_cloud_off);
                smg.setText(getContext().getString(R.string.message_no_internet));
        }
    }

    public String getErrorMessage() {
        return mErrorMessage;
    }

    public String getErrorNotification() {
        return mErrorNotification;
    }

    public void setErrorMessage(String mErrorMessage) {
        this.mErrorMessage = mErrorMessage;
    }

    public void setNotiErrorMessage(String mErrorNotification) {
        this.mErrorNotification = mErrorNotification;
    }

}
