package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.os.Build
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.annotation.RequiresApi
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.ItemRewardHistoryBinding
import com.seatel.mobilehall.ui.yes_member.activity.RewardHistoryDetailActivity
import com.seatel.mobilehall.ui.yes_member.model.RewardHistoryData
import com.seatel.mobilehall.util.SeatelUtils

class RewardHistoryAdapter(
    private val mContext: Context,
    private val rewardHistoryData: ArrayList<RewardHistoryData>
) : RecyclerView.Adapter<RewardHistoryAdapter.ViewHolder>() {



    inner class ViewHolder(private val binding: ItemRewardHistoryBinding) :
        RecyclerView.ViewHolder(binding.root) {

        @RequiresApi(Build.VERSION_CODES.O)
        fun bind(data: RewardHistoryData) {
            binding.tvItemName.text = data.rewardName
            binding.tvClaimRewardDate.text = SeatelUtils.formatDateCoin(data.createdAt)
            binding.tvRewardCoin.text = "-${data.coin}"
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding =
            ItemRewardHistoryBinding.inflate(LayoutInflater.from(parent.context), parent, false)
        return ViewHolder(binding)
    }

    @RequiresApi(Build.VERSION_CODES.O)
    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(rewardHistoryData[position])

        holder.itemView.setOnClickListener {
            RewardHistoryDetailActivity.launch(mContext, rewardHistoryData[position])
        }
    }

    override fun getItemCount(): Int = rewardHistoryData.size
}
