package com.seatel.mobilehall.ui.packages.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemLayoutLoyKobTabBinding
import com.seatel.mobilehall.databinding.ItemLayoutLoyKobTitleBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.ConfirmBuyDataPackActivity
import com.seatel.mobilehall.ui.home.adapter.TermAndServiceFooter2Adapter
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.util.Constant

class LoyKobsAdapter(
    private var mContext: Context,
    private var type: String,
    private var canSubscribe: Boolean,
    private var appProductsDetail: ValuePackSectionModel
) : BaseAdapter<RecyclerView.ViewHolder>() {

    companion object {
        private const val HEADER_TITLE = 0
        private const val HEADER_TAB = 1
    }

    private var selectedButton = 1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            HEADER_TITLE -> {
                val binding = ItemLayoutLoyKobTitleBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                HeaderTitleHolder(binding)
            }

            else -> {
                val binding = ItemLayoutLoyKobTabBinding.inflate(
                    LayoutInflater.from(parent.context), parent, false
                )
                HeaderTabHolder(binding)
            }
        }
    }

    override fun getItemCount(): Int {
        return 2
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder.itemViewType) {
            HEADER_TITLE -> {
                val binding = (holder as HeaderTitleHolder).binding
                binding.loyKobTitle.text = appProductsDetail.valuePackSecTwoModel.title
                binding.loyKobDescription.text = appProductsDetail.valuePackSecTwoModel.subTitle
            }

            HEADER_TAB -> {
                val binding = (holder as HeaderTabHolder).binding

                when (type) {
                    Constant.LoyKob -> {
                        binding.btnData.text = "Benefit offer"
                    }

                    else -> binding.btnData.text = "Data"
                }
                updateTabLayout(binding)
                binding.btnPlan.setOnClickListener {
                    selectedButton = 1
                    updateTabLayout(binding)
                    binding.containerBenefit.visibility = View.VISIBLE
                    binding.recyclerTermCondition.visibility = View.GONE
                }

                binding.btnPackage.setOnClickListener {
                    selectedButton = 2
                    updateTabLayout(binding)
                    binding.containerBenefit.visibility = View.GONE
                    binding.recyclerTermCondition.visibility = View.VISIBLE
                    binding.recyclerTermCondition.adapter = TermAndServiceFooter2Adapter(
                        mContext, appProductsDetail, true
                    )
                }

                binding.recyclerItemLoyKob.adapter = LoyKobListAdapter(
                    appProductsDetail.valuePackSecTwoModel.table, "Table", type, canSubscribe
                ) {
                    ConfirmBuyDataPackActivity.launch(
                        mContext,
                        appProductsDetail.name,
                        appProductsDetail.type,
                        it.validityDate,
                        it.valuePrice,
                        it.priceChange,
                        it.code,
                        false
                    )
                }

                binding.recyclerItemLoyKobAddon.adapter = LoyKobListAdapter(
                    appProductsDetail.valuePackSecTwoModel.addon, "Addon", type, canSubscribe
                ) {
                    ConfirmBuyDataPackActivity.launch(
                        mContext,
                        appProductsDetail.name,
                        appProductsDetail.type,
                        it.validityDate,
                        it.valuePrice,
                        it.priceChange,
                        it.code,
                        true
                    )
                }

                if (appProductsDetail.valuePackSecTwoModel.addon.isNotEmpty()) {
                    binding.btnAddon.visibility = View.VISIBLE
                    if (type == Constant.LoyKob) {
                        binding.baseValidity.text =
                            appProductsDetail.valuePackSecTwoModel.addon[0].validityDate
                    }
                }
            }
        }
    }

    class HeaderTitleHolder(val binding: ItemLayoutLoyKobTitleBinding) :
        RecyclerView.ViewHolder(binding.root)

    class HeaderTabHolder(val binding: ItemLayoutLoyKobTabBinding) :
        RecyclerView.ViewHolder(binding.root)

    private fun updateTabLayout(binding: ItemLayoutLoyKobTabBinding) {
        val defaultColor = ContextCompat.getColor(mContext, R.color.white)
        val selectedColor = ContextCompat.getDrawable(mContext, R.drawable.bg_button_round_service)

        binding.btnPlan.setBackgroundColor(defaultColor)
        binding.btnPlan.setTextColor(ContextCompat.getColor(mContext, R.color.black))
        binding.btnPackage.setBackgroundColor(defaultColor)
        binding.btnPackage.setTextColor(ContextCompat.getColor(mContext, R.color.black))

        when (selectedButton) {
            1 -> {
                binding.btnPlan.setBackgroundDrawable(selectedColor)
                binding.btnPlan.setTextColor(ContextCompat.getColor(mContext, R.color.white))
            }

            2 -> {
                binding.btnPackage.setBackgroundDrawable(selectedColor)
                binding.btnPackage.setTextColor(ContextCompat.getColor(mContext, R.color.white))
            }
        }
    }
}
