package com.seatel.mobilehall.ui.home.viewholder

import android.view.View
import android.widget.TextView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseRecyclerAdapter
import com.seatel.mobilehall.ui.home.model.SimCardPriceModel
import com.seatel.mobilehall.util.SeatelUtils

/**
 *
 *
 * @author Noel
 * @version
 * @created on 19-Oct-18
 */
class SimPriceViewHolder(itemView: View) : BaseViewHolder<SimCardPriceModel>(itemView) {
    override fun binData(baseRecyclerAdapter: BaseRecyclerAdapter<SimCardPriceModel>) {

        val txtTitleLast = itemView.findViewById<TextView>(R.id.text_title_last)
        val txtTitleFirst = itemView.findViewById<TextView>(R.id.text_title_first)
        val txtCenterSign = itemView.findViewById<TextView>(R.id.tv_center_sign)
        val txtTitle = itemView.findViewById<TextView>(R.id.text_title)


        val data = baseRecyclerAdapter.getItem(adapterPosition)
//        val rangShow = AppUtils.getTitle(data)
        txtTitleLast.visibility = View.GONE
        txtTitleFirst.visibility = View.GONE
        txtTitle.visibility = View.GONE
        txtCenterSign.visibility = View.GONE
        if (data.startPrice != data.endPrice) { //rangShow.second.isEmpty()
            txtTitle.visibility = View.VISIBLE
            txtTitle.text = SeatelUtils.translatForDialog(
                itemView.context,
                data.name
            ) //AppUtils.getTitle(data).first
        } else {
            txtTitleLast.visibility = View.VISIBLE
            txtTitleFirst.visibility = View.VISIBLE
            txtCenterSign.visibility = View.VISIBLE
            txtTitleLast.text = "$${data.startPrice}" //AppUtils.getTitle(data).second
            txtTitleFirst.text = data.name//AppUtils.getTitle(data).first
        }
    }
}