package com.seatel.mobilehall.ui.base.adapter

import android.os.Handler
import android.os.Looper
import android.view.View
import android.view.animation.Animation
import android.view.animation.AnimationUtils
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R

abstract class BaseAdapter<V : RecyclerView.ViewHolder> : RecyclerView.Adapter<V>() {
    private var lastPosition = -1
    private var delay: Handler? = null

    fun setMyAnimation(itemView: View, position: Int, animation: Animation) {
        delay = Handler(Looper.getMainLooper())
        delay?.postDelayed({
            if (position > lastPosition) {
                itemView.visibility = View.VISIBLE
                /* val animation = AnimationUtils.loadAnimation(
                    itemView.context,
                    R.anim.anim_recycler_item
                ) as Animation*/
                itemView.startAnimation(animation)
                lastPosition = position
            }
            delay?.removeCallbacksAndMessages(this)
            delay = null

        }, 500 + (position * 20).toLong())
    }

    fun setAnimations(itemView: View, position: Int) {
        delay = Handler(Looper.getMainLooper())
        delay?.postDelayed({
            if (position > lastPosition) {
                itemView.visibility = View.VISIBLE
                 val animation = AnimationUtils.loadAnimation(
                    itemView.context,
                    R.anim.anim_recycler_item
                ) as Animation
                itemView.startAnimation(animation)
                lastPosition = position
            }
            delay?.removeCallbacksAndMessages(this)
            delay = null

        }, 500 + (position * 20).toLong())
    }

    fun getLastPosition(): Int {
        return lastPosition
    }
}