package com.seatel.mobilehall.util.view

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.RelativeLayout
import androidx.core.content.ContextCompat
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ViewItemDataPackBinding

class ItemDataPackView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    private var binding: ViewItemDataPackBinding =
        ViewItemDataPackBinding.inflate(LayoutInflater.from(context), this, true)

    private enum class SelectionState { SELECTED, UNSELECTED }
    private var selectionState = SelectionState.UNSELECTED

    fun setValueData(
        price: String,
        size: String,
        strPeriod: String,
        strMb: String,
        isBuyFree: Boolean = false
    ) {
        binding.ctvValuePrice.text = price.replace(",", ".")
        binding.ctvValue.text = size
        binding.tvDayPeroid.text = strPeriod
        binding.tvSizeType.text = strMb
        binding.imgBuyFree.visibility = if (isBuyFree) View.GONE else View.VISIBLE
    }

    fun isSelectedRow(): Boolean {
        return selectionState == SelectionState.SELECTED
    }

    fun reset() {
        binding.imgCheck.visibility = View.INVISIBLE
        binding.layoutMain.background = ContextCompat.getDrawable(context, R.drawable.bg_item_data_pack)
        selectionState = SelectionState.UNSELECTED
    }

    fun onSelectItem() {
        when (selectionState) {
            SelectionState.UNSELECTED -> {
                binding.imgCheck.visibility = View.VISIBLE
                binding.layoutMain.background = ContextCompat.getDrawable(context, R.drawable.bg_item_data_pack_selected)
                selectionState = SelectionState.SELECTED
            }
            SelectionState.SELECTED -> {
                binding.imgCheck.visibility = View.INVISIBLE
                binding.layoutMain.background = ContextCompat.getDrawable(context, R.drawable.bg_item_data_pack)
                selectionState = SelectionState.UNSELECTED
            }
        }
    }
}
