package com.seatel.mobilehall.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class CircularFrameLayout extends FrameLayout {

    private Path clipPath = new Path();

    public CircularFrameLayout(Context context) {
        super(context);
    }

    public CircularFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircularFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        clipPath.reset();
        int radius = Math.min(getWidth(), getHeight()) / 2;
        clipPath.addCircle(getWidth() / 2, getHeight() / 2, radius, Path.Direction.CW);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        canvas.clipPath(clipPath);
        super.dispatchDraw(canvas);
    }
}