package com.seatel.mobilehall.ui.profile.activity

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.hardware.fingerprint.FingerprintManager
import android.os.Build
import android.os.Bundle
import android.provider.Settings
import androidx.annotation.RequiresApi
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityEnableFingerprintBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils

class EnableFingerprintActivity : BaseActivity<ActivityEnableFingerprintBinding>() {
    override fun getViewBinding(): ActivityEnableFingerprintBinding {
        return ActivityEnableFingerprintBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //   setContentView(R.layout.activity_enable_fingerprint)
        activityEnterFadeInAnimation()
        binding.buttonNeedFingerprint.setOnClickListener {

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                if (hasEnrolledFingerprints()) {
                    startActivityForResult(
                        Intent(
                            this,
                            FingerprintConfirmationActivity::class.java
                        ), Constant.REQUEST_FINGERPRINT_CODE
                    )
                } else {
                    val message = getString(R.string.fingerprint_message)
                    SeatelAlertDialog.with(this, SeatelUtils.translatForDialog(this, message))
                        .setPositiveButton(getString(R.string.yes)) { dialog, _ ->
                            dialog.dismiss()
                            startActivityForResult(Intent(Settings.ACTION_SETTINGS), 0)

                        }
                        .setNegativeButton(getString(R.string.no)) { dialog, _ -> dialog.dismiss() }
                        .show()
                }
            }
        }
        binding.buttonNoNeedFingerprint.setOnClickListener {
            onBackPressed()
        }
    }

    @RequiresApi(Build.VERSION_CODES.M)
    private fun hasEnrolledFingerprints(): Boolean {
        val fingerprintManager = getSystemService(FingerprintManager::class.java)
        return fingerprintManager.hasEnrolledFingerprints()
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitFadeOutAnimation()
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.fingerprint_id)
    }

    override fun isCancelBackType(): Boolean {
        return true
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)

        if (requestCode == Constant.REQUEST_FINGERPRINT_CODE)
            if (resultCode == RESULT_OK) {
                val intent = Intent()
                intent.putExtra(
                    Constant.FINGERPRINT_RESULT,
                    data?.getStringExtra(Constant.FINGERPRINT_RESULT)
                )
                setResult(RESULT_OK, intent)
                finish()
            }
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, EnableFingerprintActivity::class.java)
            (context as Activity).startActivityForResult(
                intent,
                Constant.REQUEST_FINGERPRINT_CODE
            )
        }
    }
}
