package com.seatel.mobilehall.ui.login.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.login.interactor.VerifyPinInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject

class VerifyPinPresenter(
    private var mContext: Context,
    private var mPinView: VerifyPinInteractor.View
) : VerifyPinInteractor.Presenter {

    override fun onVerifyPinNumber(pin: String) {
        postPinVerifyRequest(pin).setOnErrorListener { error ->
            mPinView.onVerifyPinNumberFailed(error)
        }.setOnResponseListener { response ->
            mPinView.onVerifyPinNumberSucceed(response as JSONObject)
        }.execute()
    }

    private fun postPinVerifyRequest(pin: String): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.VERIFY_PIN
            }

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("pin", pin)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }
        }
    }
}