package com.seatel.mobilehall.ui.login.fragment

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.login.activity.LoginActivity
import com.seatel.mobilehall.ui.login.interactor.ConfirmSignUpInteractor
import com.seatel.mobilehall.ui.login.presenter.ConfirmSignUpPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView
import com.seatel.mobilehall.databinding.FragmentNewPasswordBinding
import java.util.*

class NewPasswordFragment : MainFragment(), ConfirmSignUpInteractor.View {

    private var mPhone = ""
    private var mCode = "0"
    private lateinit var mNewPasswordPresenter: ConfirmSignUpPresenter
    private lateinit var binding: FragmentNewPasswordBinding

    override fun onAttach(context: Context) {
        super.onAttach(context)
        setmContext(context)
        setActivity(context as LoginActivity)
        setFragmentLayout(R.layout.fragment_new_password)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding = FragmentNewPasswordBinding.bind(view) // Initialize ViewBinding
        init()
    }

    private fun init() {
        mNewPasswordPresenter = ConfirmSignUpPresenter(requireContext(), this)

        binding.imageViewBack.setOnClickListener { onBackPress() }
        binding.btnYes.setOnClickListener {
            SeatelUtils.hideKeyboard(getMainActivity())
            startPostNewPassword()
        }

        binding.ctvPassword.hint = binding.ctvPassword.hint
        binding.ctvConfirmPassword.hint = binding.ctvConfirmPassword.hint
    }

    fun setDataPost(phone: String, code: String) {
        this.mPhone = phone
        this.mCode = code
    }

    private fun showLoginScreen() {
        getmMainFragmentPresenter()!!.addFragment(LoginFragment(), true)
        SeatelUtils.hideKeyboard(getMainActivity())
    }

    override fun onConfirmSucceed() {
        binding.errorView.visibility = View.GONE
        SeatelAlertDialog.with(requireContext(), getString(R.string.forgot_password_success))
            .setPositiveButton(getString(R.string.yes)) { _, _ ->
                showLoginScreen()
            }.show()
    }

    override fun onConfirmFailed(error: VolleyError) {
        binding.errorView.visibility = View.GONE
        val smsError = SeatelSuperRequest.getErrorMessageFrom(error)
        if (smsError.isNotEmpty() && smsError.lowercase(Locale.getDefault()).contains("the subscriber is not active")) {
            SeatelAlertDialog.with(requireContext(), smsError)
                .setPositiveButton(getString(R.string.yes)) { _, _ ->
                    showLoginScreen()
                }.show()
        } else {
            SeatelUtils.showErrorDialog(requireContext(), smsError)
        }
    }

    private fun validateControl(): Boolean {
        val password = binding.ctvPassword.text
        val confirmPassword = binding.ctvConfirmPassword.text

        var msg = ""

        if (password!!.isEmpty())
            msg = getString(R.string.new_password_empty)
        else if (confirmPassword!!.isEmpty())
            msg = getString(R.string.confirm_new_password_empty)
        else if (!TextUtils.equals(password, confirmPassword))
            msg = getString(R.string.confirm_new_password_not_match)
        else if (password.length < 6)
            msg = getString(R.string.password_at_least_6_digit)

        if (!TextUtils.isEmpty(msg)) {
            SeatelAlertDialog.with(requireContext(), msg).show()
            return false
        }
        return true
    }

    override fun onDestroy() {
        super.onDestroy()
        mNewPasswordPresenter.onDestroy()
    }

    private fun startPostNewPassword() {
        if (validateControl()) {
            binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
            mNewPasswordPresenter.onConfirmCode(
                "v2/",
                mCode,
                "",
                "",
                mPhone,
                binding.ctvConfirmPassword.text.toString(),
                "",
                Constant.RESET_PASSWORD
            )
        }
    }

    override fun onBackPress() {
        getmMainFragmentPresenter()!!.addFragment(ForgotPasswordFragment(), true)
        SeatelUtils.hideKeyboard(getMainActivity())
    }
}
