package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.seatel.mobilehall.R;
import com.seatel.mobilehall.util.SeatelUtils;
import com.seatel.mobilehall.util.view.ViewDataPackTabFooter;

import java.util.List;

public class DataStandardRateAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private final Context mContext;
    private final List<ViewDataPackTabFooter.TableModel> mTableModel;
    private final int VIEW_TYPE_TITLE = 0;
    private final int VIEW_TYPE_SUBTITLE = 1;

    public DataStandardRateAdapter(Context mContext, List<ViewDataPackTabFooter.TableModel> tableModel) {
        this.mContext = mContext;
        this.mTableModel = tableModel;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (VIEW_TYPE_TITLE == viewType)
            return new TitleViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_table_header, parent, false));
        else
            return new DetailViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_data_pack_detail, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof TitleViewHolder)
            ((TitleViewHolder) holder).onBind();
        else if (holder instanceof DetailViewHolder)
            ((DetailViewHolder) holder).onBind(mTableModel.get(position - 1));
    }

    @Override
    public int getItemViewType(int position) {

        if (position == 0) return VIEW_TYPE_TITLE;
        else return VIEW_TYPE_SUBTITLE;
    }

    @Override
    public int getItemCount() {
        return mTableModel.size() + 1;
    }

    private class TitleViewHolder extends RecyclerView.ViewHolder {

        private TitleViewHolder(View itemView) {
            super(itemView);
        }

        private void onBind() {
        }
    }

    private class DetailViewHolder extends RecyclerView.ViewHolder {

        private final TextView mDataPack;
        private final TextView mFeeTop;
        private final TextView mFeeBottom;
        private final TextView mDataTop;
        private final TextView mDataBottom;
        private final TextView mActivationTop;
        private final TextView mActivationBottom;
        private final TextView mValTop;
        private final TextView mValBottom;
        private final View mRowBottom;

        private DetailViewHolder(View itemView) {
            super(itemView);

            mDataPack = itemView.findViewById(R.id.text_view_data_pack);

            mFeeTop = itemView.findViewById(R.id.text_view_fee_top);
            mFeeBottom = itemView.findViewById(R.id.text_view_fee_bottom);

            mDataTop = itemView.findViewById(R.id.text_view_data_top);
            mDataBottom = itemView.findViewById(R.id.text_view_data_bottom);

            mActivationTop = itemView.findViewById(R.id.text_view_activation_top);
            mActivationBottom = itemView.findViewById(R.id.text_view_activation_bottom);

            mValTop = itemView.findViewById(R.id.text_view_validity_top);
            mValBottom = itemView.findViewById(R.id.text_view_validity_bottom);

            mRowBottom = itemView.findViewById(R.id.view_row_bottom);
        }

        private void updateHeightRow() {
            ViewGroup.LayoutParams params = mDataPack.getLayoutParams();
            params.height = SeatelUtils.Companion.convertDpToPx(mContext, 50);// 130;
            mDataPack.setLayoutParams(params);
        }


        private void onBind(ViewDataPackTabFooter.TableModel tableModel) {

            mDataPack.setText(tableModel.getDataPack());

            mFeeTop.setText(tableModel.getFees().get(0));
            if (tableModel.getFees().size() > 1)
                mFeeBottom.setText(tableModel.getFees().get(1));
            else {
                mRowBottom.setVisibility(View.GONE);
                updateHeightRow();
            }

            mDataTop.setText(tableModel.getDatas().get(0));
            if (tableModel.getDatas().size() > 1)
                mDataBottom.setText(tableModel.getDatas().get(1));
            else {
                mRowBottom.setVisibility(View.GONE);
                updateHeightRow();
            }

            mActivationTop.setText(tableModel.getActivations().get(0));
            if (tableModel.getActivations().size() > 1)
                mActivationBottom.setText(tableModel.getActivations().get(1));
            else {
                mRowBottom.setVisibility(View.GONE);
                updateHeightRow();
            }

            mValTop.setText(tableModel.getValidity().get(0));
            if (tableModel.getValidity().size() > 1)
                mValBottom.setText(tableModel.getValidity().get(1));
            else {
                mRowBottom.setVisibility(View.GONE);
                updateHeightRow();
            }

        }
    }
}
