package com.seatel.mobilehall.ui.home.activity


import ProductServiceAdapter
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityProductServiceBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.interactor.AppProductsInteractor
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel
import com.seatel.mobilehall.ui.home.presenter.AppProductsPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.customview.ErrorHandleView


class ProductServiceActivity : BaseActivity<ActivityProductServiceBinding>(),
    AppProductsInteractor.View {

    private val productService: ArrayList<AppProductsResponseModel> = ArrayList()
    private var mAppProductsPresenter: AppProductsPresenter? = null
    var canSubscribe: Boolean = false
    override fun getViewBinding(): ActivityProductServiceBinding {
        return ActivityProductServiceBinding.inflate(layoutInflater)
    }

    @Override
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //   setContentView(R.layout.activity_product_service)
        activityEnterRightAnimation()
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        mAppProductsPresenter = AppProductsPresenter(this, this)
        mAppProductsPresenter?.onGetAppProducts(getPhoneLogin())

    }

    private fun setAdapterData() {
        binding.productServiceRecyclerView.layoutManager = LinearLayoutManager(this)
        binding.productServiceRecyclerView.adapter = ProductServiceAdapter(this, productService) {

            when (it.code) {
                "one-plan" -> {
                    OnePlanDetailActivity.lunch(this)
                }

                "international-call" -> {
                    binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
                    InternationalCallDetailActivity.lunch(this)
                }

                "loy-kobs" -> LoyKobActivity.launch(
                    this, it.canSubscribe!!, it.code!!, Constant.LoyKob
                )

                else -> {
                    LoyKobActivity.launch(
                        this, it.canSubscribe!!, it.code!!, "Any"
                    )
                }
            }

        }
    }

    override fun onGetAppProductsSucceed(appProductsList: ArrayList<AppProductsResponseModel>) {
        Log.d("---appProduct", "onGetAppProductsSucceed: ${Gson().toJson(appProductsList)}")
        productService.addAll(appProductsList)
        setAdapterData()
        binding.errorView.visibility = View.GONE
    }

    override fun onGetAppProductsFailed(error: VolleyError) {
        when (error) {
            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.message_no_internet)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                binding.errorView.errorMessage = getString(R.string.no_data)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    override fun onPause() {
        super.onPause()
        binding.errorView.visibility = View.GONE
    }

    override fun onBackPressed() {
        super.onBackPressed()
        binding.errorView.visibility = View.GONE
        activityExitLeftAnimation()
    }

    override fun getToolbarTitle(): String {
        return getString(R.string.product_and_service)
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, ProductServiceActivity::class.java)
            context.startActivity(intent)
        }
    }


}

