package com.seatel.mobilehall.util.lang

import android.content.Context
import android.content.SharedPreferences

class FirstLoginPreference(context: Context) {

    private var sharedPref: SharedPreferences? = null
    // private var instance: FirstLoginPreference? = null

    init {
        this.sharedPref = context.getSharedPreferences("SeatelFirstLogin", Context.MODE_PRIVATE)
    }

    companion object {
        @Volatile
        private var instance: FirstLoginPreference? = null

        fun getInstance(context: Context): FirstLoginPreference? {
            if (instance == null)  // NOT thread safe!
                instance = FirstLoginPreference(context)
            return instance
        }
    }

//    @Synchronized
//    fun getConstant(context: Context): LanguagePreference {
//        if (instance == null) {
//            instance = LanguagePreference(context)
//        }
//        return instance as LanguagePreference
//    }

    fun getFirstLoginPreference(): Boolean? {
        return sharedPref?.getBoolean("SEATELFIRSTLOGIN", false)
    }

    fun setFirstLoginPreference(first: Boolean) {
        sharedPref?.edit()?.putBoolean("SEATELFIRSTLOGIN", first)?.apply()
    }

    fun getIsShowPromotionInternetForAll(): Boolean? {
        return sharedPref?.getBoolean("yesifa", false)
    }

    fun setIsShowPromotionInternetForAll(yesifa: Boolean) {
        sharedPref?.edit()?.putBoolean("yesifa", yesifa)?.apply()
    }

    fun getIsShowHappyChinesNewYear(): Boolean? {
        return sharedPref?.getBoolean("HAPPYCNY", false)
    }

    fun setIsShowHappyChinesNewYear(cny: Boolean) {
        sharedPref?.edit()?.putBoolean("HAPPYCNY", cny)?.apply()

    }

    fun getFirstEnableFingerprintPreference(): Boolean? {
        return sharedPref?.getBoolean("DAIKUFIRSTENABLEFINGERPRINT", false)
    }

    fun setFirstEnableFingerprintPreference(first: Boolean) {
        sharedPref?.edit()?.putBoolean("DAIKUFIRSTENABLEFINGERPRINT", first)?.apply()
    }

    fun getIsForceUpdatePreference(): Boolean? {
        return sharedPref?.getBoolean("forceupdate", false)
    }

    fun setIsForceUpdatePreference(first: Boolean) {
        sharedPref?.edit()?.putBoolean("forceupdate", first)?.apply()
    }

    fun setFirstInstall(firstInstall: Boolean) {
        sharedPref?.edit()?.putBoolean("FIRST_INSTALL", firstInstall)?.apply()
    }

    fun isFirstInstall(): Boolean? {
        return sharedPref?.getBoolean("FIRST_INSTALL", false)
    }

}