package com.seatel.mobilehall.util.customview

import android.annotation.SuppressLint
import android.app.Dialog
import android.view.View
import android.widget.Button
import androidx.coordinatorlayout.widget.CoordinatorLayout
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.profile.activity.ProfileFaceScanActivity

open class BottomSheetFaceScanFragment : BottomSheetDialogFragment() {

    private var mParams: CoordinatorLayout.LayoutParams? = null
    private lateinit var bottomSheetBehavior: BottomSheetBehavior<*>


    @SuppressLint("RestrictedApi")
    override fun setupDialog(dialog: Dialog, style: Int) {

        super.setupDialog(dialog, style)
        val view = View.inflate(context, getLayoutId(), null)
        dialog.setContentView(view)

        if (mParams == null) {
            mParams = (view.parent as View).layoutParams as CoordinatorLayout.LayoutParams
        }

        val behavior = mParams!!.behavior
        (view.parent as View).setBackgroundColor(resources.getColor(android.R.color.transparent))/* bottomSheetBehavior = BottomSheetBehavior.from<View>(view.root_layout)

         if (behavior != null && behavior is BottomSheetBehavior<*>) {
             bottomSheetBehavior.setBottomSheetCallback(object :
                 BottomSheetBehavior.BottomSheetCallback() {
                 override fun onSlide(bottomSheet: View, slideOffset: Float) {

                 }

                 override fun onStateChanged(bottomSheet: View, newState: Int) {
                     if (newState == BottomSheetBehavior.STATE_HIDDEN) {
                         dismiss()
                     }
                 }

             })
         }*/

        view.findViewById<Button>(R.id.btn_next).setOnClickListener {
            ProfileFaceScanActivity.launchForResult(requireContext())
            dismiss()

        }

    }

    open fun getLayoutId(): Int {
        return R.layout.layout_bottom_sheet_face_scan_dialog
    }


}