package com.seatel.mobilehall.util.customview

import android.Manifest
import android.app.Activity
import android.app.DatePickerDialog
import android.app.Dialog
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.net.Uri
import android.os.Build
import android.os.Environment
import android.provider.MediaStore
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.util.AttributeSet
import android.util.Log
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.widget.Button
import android.widget.DatePicker
import android.widget.EditText
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.content.FileProvider
import coil.load
import com.bumptech.glide.Glide
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.data.prefs.ProfileSharedPreference
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.databinding.ViewActivateBuySimBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.login.model.ProfileModel
import com.seatel.mobilehall.ui.profile.activity.ScanMRZActivity
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.PermissionUtil
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import org.json.JSONArray
import java.io.File
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date
import java.util.Locale

@Suppress("RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
class ActivateBuySimView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
    isSimProfle: Boolean = false
) : LinearLayout(context, attrs, defStyleAttr), View.OnClickListener,
    DatePickerDialog.OnDateSetListener {

    fun getmEditTextName(): EditText = binding!!.editTextName
    fun setEditeTextName(text: String) {
        binding?.editTextName?.setText(text)
    }

    fun getEditTextName(): String {
        return binding!!.editTextName.text.toString().trim()
    }


    fun getTvDate(): String {
        return binding!!.tvDate.text.toString().trim()
    }

    fun layoutUploadUser(): LinearLayout = binding!!.layoutUploadUser
    fun getmTvDate(): TextView = binding!!.tvDate
    fun setTvDate(text: String) {
        binding?.tvDate?.text = text
    }

    fun getTvMonth(): String {
        return binding!!.tvMonth.text.toString().trim()
    }

    fun getTvYear(): String {
        return binding!!.tvYear.text.toString().trim()
    }

    fun getmTvSex(): TextView = binding!!.tvSex
    fun getTvSex(): String {
        return binding!!.tvSex.text.toString()
    }

    fun setTvSex(text: String) {
        binding?.tvSex?.text = text
    }

    fun isRadioButtonCurrentInfo(): Boolean {
        return binding!!.radioButtonCurrentInfo.isChecked
    }

    lateinit var tvIdType: TextView
    fun getmTvIdType(): TextView = binding!!.tvIdType

    fun getTvIdType(): String {
        return binding!!.tvIdType.text.toString()
    }


    fun setTvIdType(text: String) {
        binding?.tvIdType?.text = text
    }

    lateinit var editTextCardNumber: EditText
    fun getmEditTextCardNumber(): EditText = binding!!.editTextCardNumber

    fun getEditTextCardNumber(): String {
        return binding!!.editTextCardNumber.text.toString().trim()
    }

    fun setEditTextCardNumber(text: String) {
        binding?.editTextCardNumber?.setText(text)
    }

    private var certificateModel = ArrayList<BottomChooserDialog.BottomChooserModel>()
    val calendar = Calendar.getInstance()
    var imageType = ""
    var mOutputFileBack: File? = null
    var mOutputBack: String? = null
    var mOutputFileFront: File? = null
    var mOutputFront: String? = null
    var mOutputFileUser: File? = null
    var mOutputUser: String? = null
    var mImageCaptureUri: Uri? = null
    private var profile: ProfileModel? = null
    var dateOfBirth = "" //this use for post data to server
    private var idCertificationType = 0
    var mGenderKeyPost = ""
    private var mCertificationNamePost: String? = ""
    private var mIdType = ""
    private var mPhotoRequest: PermissionUtil.PermissionRequestObject? = null
    private var isUpdateSimProfile: Boolean = false
    private var profileSharedPreference = ProfileSharedPreference.getInstance(context)
    private var scannable: Boolean = false
    var dateOfExpiry: String? = null
    var nationality: String? = null

    // ViewBinding reference
    private var binding: ViewActivateBuySimBinding? = null

    fun getIdCertType(): Int {
        return idCertificationType
    }

    fun getGenderKeyPost(): String {
        return mGenderKeyPost.lowercase(Locale.getDefault())
    }

    fun getCertificationNamePost(): String? {
        return mCertificationNamePost
    }

    override fun onDateSet(view: DatePicker?, year: Int, month: Int, dayOfMonth: Int) {
        calendar.set(Calendar.YEAR, year)
        calendar.set(Calendar.MONTH, month)
        calendar.set(Calendar.DAY_OF_MONTH, dayOfMonth)
        val sdf = SimpleDateFormat("dd MMM yyyy", Locale.US)
        dateOfBirth = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US).format(calendar.time)
        ProfileSharedPreference.getInstance(context)?.setDob(dateOfBirth)
        try {
            binding?.tvDate?.text = sdf.format(calendar.time).split(" ")[0]
            ProfileSharedPreference(context).setDay(sdf.format(calendar.time).split(" ")[0])
            binding?.tvMonth?.text = sdf.format(calendar.time).split(" ")[1]
            ProfileSharedPreference(context).setMonth(sdf.format(calendar.time).split(" ")[1])
            binding?.tvYear?.text = sdf.format(calendar.time).split(" ")[2]
            ProfileSharedPreference(context).setYear(sdf.format(calendar.time).split(" ")[2])
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun updatedDocTypeSelected(data: BottomChooserDialog.BottomChooserModel) {
        binding!!.tvIdType.text = data.name
        mCertificationNamePost = data.name
        idCertificationType = data.id
        binding!!.editTextCardNumber.isEnabled = true
        ProfileSharedPreference.getInstance(context)?.setDocumentType(data.name)
    }

    override fun onClick(p0: View?) {
        when (p0?.id) {
            R.id.tv_month, R.id.tv_date, R.id.tv_year -> showCalendar()
            R.id.tv_id_type -> getIdType()
            R.id.tv_sex -> showChooserDialog(getSex(), binding!!.tvSex)
            R.id.layout_upload_front -> {
                imageType = "front"
                chooseImage()
            }

            R.id.layout_upload_back -> {
                imageType = "back"
                chooseImage()
            }

            R.id.layout_upload_user -> {
                imageType = "user"
                //  chooseImage()
            }

            R.id.btn_scan -> {
                showPermissionCamera()
            }
        }
    }

    private fun showPermissionCamera() {
        val mActivity = context as AppCompatActivity
        mPhotoRequest = PermissionUtil.with(mActivity).request(Manifest.permission.CAMERA)
            .onAllGranted(object : PermissionUtil.Func() {
                override fun call() {
                    ScanMRZActivity.launchForResult(context)
                }

            }).onAnyDenied(object : PermissionUtil.Func() {
                override fun call() {
                    Toast.makeText(
                        context, "Camera permission is needed to open camera.", Toast.LENGTH_LONG
                    ).show()
                }
            }).askPermission(999)
    }

    private fun chooseImage() {
        val dialog = Dialog(context)
        val view = LayoutInflater.from(context).inflate(R.layout.dialog_choose_image, null)
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE)
        dialog.setContentView(view)
        if (dialog.window != null) {
            dialog.window!!.setDimAmount(0.5f)
            dialog.window!!.setLayout(
                WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT
            )
            dialog.window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            dialog.window!!.setGravity(Gravity.BOTTOM)
            dialog.window!!.attributes.windowAnimations = R.style.DialogAnimationSlideUpDown
        }
        view.findViewById<Button>(R.id.button_cancel).setOnClickListener {
            dialog.dismiss()
        }

        view.findViewById<LinearLayout>(R.id.parent_camera).setOnClickListener {
            openCamera()
            dialog.dismiss()
        }
        view.findViewById<LinearLayout>(R.id.parent_gallery).setOnClickListener {
            openGallery()
            dialog.dismiss()
        }
        dialog.show()
    }

    private fun openCamera() {
        if (ContextCompat.checkSelfPermission(
                context, Manifest.permission.CAMERA
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            ActivityCompat.requestPermissions(
                context as Activity, arrayOf(Manifest.permission.CAMERA), Constant.REQUEST_CAMERA
            )
        } else {
            val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
            val timeStamp = SimpleDateFormat("yyyyMMDD_HHmmss", Locale.getDefault()).format(Date())
            val imageFileName = "IMG_$timeStamp.jpg"
            try {
                val mFile = File.createTempFile(
                    "IMG_$timeStamp",
                    ".jpg",
                    context.getExternalFilesDir(Environment.DIRECTORY_PICTURES)
                )
                mImageCaptureUri = FileProvider.getUriForFile(
                    context, BuildConfig.APPLICATION_ID + ".provider", mFile
                )
                intent.putExtra(MediaStore.EXTRA_OUTPUT, mImageCaptureUri)
                intent.putExtra("listPhotoName", imageFileName)
                (context as Activity).startActivityForResult(intent, Constant.REQUEST_TAKE_PHOTO)
            } catch (e: IOException) {
                e.printStackTrace()
            }

        }
    }

    private fun openGallery() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            if (ContextCompat.checkSelfPermission(
                    context, Manifest.permission.READ_MEDIA_IMAGES
                ) != PackageManager.PERMISSION_GRANTED
            ) {
                ActivityCompat.requestPermissions(
                    context as Activity,
                    arrayOf(Manifest.permission.READ_MEDIA_IMAGES),
                    Constant.REQUEST_GELLARY
                )
            } else {
                val intent =
                    Intent(Intent.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI)
                (context as Activity).startActivityForResult(intent, Constant.REQUEST_LOAD_PHOTO)
            }

        } else {
            if (ContextCompat.checkSelfPermission(
                    context, Manifest.permission.READ_EXTERNAL_STORAGE
                ) != PackageManager.PERMISSION_GRANTED
            ) {
                ActivityCompat.requestPermissions(
                    context as Activity,
                    arrayOf(Manifest.permission.READ_EXTERNAL_STORAGE),
                    Constant.REQUEST_GELLARY
                )
            } else {
                val intent =
                    Intent(Intent.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI)
                (context as Activity).startActivityForResult(intent, Constant.REQUEST_LOAD_PHOTO)
            }
        }

    }

    fun doCrop(requestCode: Int) {
        try {
            val mOutputFile = File.createTempFile(
                "crop_" + Calendar.getInstance().timeInMillis + "_",
                ".jpg",
                context.getExternalFilesDir(Environment.DIRECTORY_PICTURES)
            )
            val mImageCropUri = FileProvider.getUriForFile(
                context, BuildConfig.APPLICATION_ID + ".provider", mOutputFile
            )
            when (imageType) {
                "front" -> mOutputFileFront = mOutputFile
                "back" -> mOutputFileBack = mOutputFile
                else -> mOutputFileUser = mOutputFile
            }

            val intent = Intent("com.android.camera.action.CROP")
            intent.setDataAndType(mImageCaptureUri, "image/*")
            intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
            intent.addFlags(Intent.FLAG_GRANT_WRITE_URI_PERMISSION)
            intent.putExtra("scale", true)
            intent.putExtra(MediaStore.EXTRA_OUTPUT, mImageCropUri)
            val resInfoList = context.packageManager.queryIntentActivities(intent, 0)
            if (resInfoList.size == 0) {
                SeatelAlertDialog.with(context, "PHOTO CROPPING IS INDEED NOT SUPPORTED.").show()
            }
            for (i in resInfoList.indices) {
                if (resInfoList[i] != null) {
                    val packageName = resInfoList[i].activityInfo.packageName
                    if ("com.google.android.apps.photos" == packageName) {
                        intent.component =
                            ComponentName(packageName, resInfoList[i].activityInfo.name)
                    }
                    context.grantUriPermission(
                        packageName,
                        mImageCropUri,
                        Intent.FLAG_GRANT_WRITE_URI_PERMISSION or Intent.FLAG_GRANT_READ_URI_PERMISSION
                    )
                }
            }
            (context as Activity).startActivityForResult(intent, requestCode)
        } catch (e: IOException) {
            e.printStackTrace()
        }

    }

    private fun getSex(): ArrayList<BottomChooserDialog.BottomChooserModel> {
        val sex = ArrayList<BottomChooserDialog.BottomChooserModel>()
        sex.add(BottomChooserDialog.BottomChooserModel(0, "Male"))
        sex.add(BottomChooserDialog.BottomChooserModel(0, "Female"))
        return sex
    }

    private fun showCalendar() {
        DatePickerDialog(
            context,
            this,
            calendar.get(Calendar.YEAR),
            calendar.get(Calendar.MONTH),
            calendar.get(Calendar.DAY_OF_MONTH)
        ).show()
    }

    fun displayForUpdateSimNoneSeatelUser() {
        binding?.tvIdType?.text = ""
        binding?.editTextCardNumber?.setText("")
        binding!!.radioGroupSelect.visibility = View.GONE
        binding!!.radioButtonCurrentInfo.isChecked = false
    }

    fun displayForUpdateSimProfile() {
        binding?.mainView?.setBackgroundColor(Color.parseColor("#ffffff"))
        binding?.viewSubMain?.setBackgroundColor(Color.parseColor("#ffffff"))
        binding?.tvIdType?.text = ""
        binding?.editTextCardNumber?.setText("")
        binding?.editTextName?.visibility = View.VISIBLE
        binding?.titleNote?.visibility = View.GONE
        binding?.radioGroupSelect?.visibility = View.GONE
        binding?.viewDob?.visibility = View.VISIBLE
        binding?.titleYourPhoto?.visibility = View.VISIBLE
        binding?.viewBlockProfile?.visibility = View.VISIBLE
    }

    fun displayForOrderPickUp() {
        binding?.mainView?.setBackgroundColor(Color.parseColor("#ffffff"))
        binding?.viewSubMain?.setBackgroundColor(Color.parseColor("#ffffff"))
        binding?.editTextName?.visibility = View.VISIBLE
        binding?.titleNote?.visibility = View.GONE
        binding?.radioGroupSelect?.visibility = View.GONE
        binding?.viewDob?.visibility = View.VISIBLE
        binding?.titleYourPhoto?.visibility = View.VISIBLE
        binding?.viewBlockProfile?.visibility = View.VISIBLE
        binding?.imageViewUser?.visibility = View.INVISIBLE

        Log.d(
            "TAG",
            "displayForOrderPickUp:" + " ${profileSharedPreference?.getDocumentType()} " + "${profileSharedPreference?.getId()} " + "${profileSharedPreference?.getName()} " + "${profileSharedPreference?.getGender()} " + "${profileSharedPreference?.getDay()} " + "${profileSharedPreference?.getMonth()}" + "${profileSharedPreference?.getYear()}"
        )

        mCertificationNamePost = profileSharedPreference?.getDocumentType()
        binding?.tvIdType?.text = profileSharedPreference?.getDocumentType()
        binding?.editTextCardNumber?.setText(profileSharedPreference?.getId())
        binding?.editTextName?.setText(profileSharedPreference?.getName())
        binding?.tvSex?.text = profileSharedPreference?.getGender()
        binding?.tvDate?.text = profileSharedPreference?.getDay()
        binding?.tvMonth?.text = profileSharedPreference?.getMonth()
        binding?.tvYear?.text = profileSharedPreference?.getYear()

        if (profileSharedPreference?.getFrontId()!!.isNotBlank()) {
            binding?.imageViewFront?.visibility = View.VISIBLE
            binding?.imageViewFront?.load(profileSharedPreference?.getFrontId())
            mOutputFront = profileSharedPreference?.getFrontId()
        }

        if (profileSharedPreference?.getBackId()!!.isNotBlank()) {
            binding?.imageViewBack?.visibility = View.VISIBLE
            binding?.imageViewBack?.load(profileSharedPreference?.getBackId())
            mOutputBack = profileSharedPreference?.getBackId()
        }

        if (profileSharedPreference?.getProfileImage()!!.isNotBlank()) {
            binding?.imageViewUser?.visibility = View.VISIBLE
            binding?.imageViewUser?.load(profileSharedPreference?.getProfileImage())
            mOutputUser = profileSharedPreference?.getProfileImage()
        }

        binding?.editTextCardNumber?.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                ProfileSharedPreference.getInstance(context)?.setId(s.toString())
            }

            override fun afterTextChanged(s: Editable?) {}
        })

        binding?.editTextName?.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                ProfileSharedPreference.getInstance(context)?.setName(s.toString())
            }

            override fun afterTextChanged(s: Editable?) {}
        })
    }

    init {
        binding = ViewActivateBuySimBinding.inflate(LayoutInflater.from(getContext()), this, true)

        binding?.radioButtonNewId?.text =
            SeatelUtils.translatForDialog(getContext(), "Register new ID")
        binding?.radioButtonCurrentInfo?.text =
            SeatelUtils.translatForDialog(getContext(), "Use my current info")
        binding?.tvIdType?.hint = SeatelUtils.translatForDialog(getContext(), "Document Type")
        binding?.tvSex?.hint = SeatelUtils.translatForDialog(getContext(), "Gender")
        binding?.editTextCardNumber?.hint = SeatelUtils.translatForDialog(getContext(), "ID#")
        binding?.editTextName?.hint = SeatelUtils.translatForDialog(getContext(), "Name")
        binding?.tvDate?.hint = SeatelUtils.translatForDialog(getContext(), "Day")
        binding?.tvMonth?.hint = SeatelUtils.translatForDialog(getContext(), "Month")
        binding?.tvYear?.hint = SeatelUtils.translatForDialog(getContext(), "Year")

        binding?.tvDate?.setOnClickListener(this)
        binding?.tvMonth?.setOnClickListener(this)
        binding?.tvYear?.setOnClickListener(this)
        binding?.tvSex?.setOnClickListener(this)
        binding?.tvSex?.setOnClickListener(this)
        binding?.tvIdType?.setOnClickListener(this)
        binding?.btnScan?.setOnClickListener(this)
        binding?.layoutUploadFront?.setOnClickListener(this)
        binding?.layoutUploadBack?.setOnClickListener(this)
        binding?.layoutUploadUser?.setOnClickListener(this)

        binding!!.frameCurrentInfo.setOnClickListener {
            if (OrderingManager.getInstance().getPhoneNumber(context)
                    .startsWith("018") || OrderingManager.getInstance().getPhoneNumber(context)
                    .startsWith("18") || OrderingManager.getInstance().getPhoneNumber(context)
                    .startsWith("85518")
            ) {
                binding!!.radioButtonCurrentInfo.isChecked = true
                binding!!.radioButtonNewId.isChecked = false
                changeInfo()
            } else {
                SeatelAlertDialog.with(
                    context, context.getString(R.string.message_register_sim_none_seatel)
                ).show()
            }
        }

        binding!!.frameNewInfo.setOnClickListener {
            binding!!.radioButtonNewId.isChecked = true
            binding!!.radioButtonCurrentInfo.isChecked = false
            changeInfo()
        }
//        binding!!.radioButtonCurrentInfo.setOnCheckedChangeListener { buttonView, isChecked ->
//            //check non seatel user can't use current info
//
//        }
//        binding!!.radioButtonNewId.setOnCheckedChangeListener { buttonView, isChecked ->
//            buttonView.setTextColor(if (isChecked) ContextCompat.getColor(context, R.color.colorPrimary) else ContextCompat.getColor(context, R.color.colorGray))
//            changeInfo()
//        }

        if (SeatelSharePreferences.getInstance(context)!!.getPhoneLogin()!!.isNotEmpty()) {
            profile = (getContext() as BaseActivity<*>).getProfile()
            if (profile != null) {
                binding!!.tvIdType.text = profile?.certType
                if (profile?.certType != null) mCertificationNamePost = profile?.certType!!
                binding!!.editTextCardNumber.setText(profile?.certNumber)
                //    if (binding!!.editTextCardNumber.text.isNotEmpty()) binding!!.editTextCardNumber.isEnabled = true
                if (!TextUtils.isEmpty(profile?.imageUrl) && !isSimProfle) {
                    binding!!.imageViewUser.visibility = View.VISIBLE
                    Glide.with(context).load(profile?.imageUrl).dontAnimate()
                        .into(binding!!.imageViewUser)
                }
            }
        }

    }

    private fun changeInfo() {

        if (binding!!.radioButtonCurrentInfo.isChecked) {
            binding!!.radioButtonCurrentInfo.setTextColor(
                ContextCompat.getColor(
                    context, R.color.colorPrimary
                )
            )
            binding!!.radioButtonNewId.setTextColor(
                ContextCompat.getColor(
                    context,
                    R.color.colorGray
                )
            )
            binding!!.tvIdType.text = profile?.certType
            binding!!.editTextName.setText(profile?.custName)
            binding!!.editTextCardNumber.setText(profile?.certNumber)
            if (!TextUtils.isEmpty(profile?.imageUrl)) {
                binding!!.imageViewUser.visibility = View.VISIBLE
                Glide.with(context).load(profile?.imageUrl).dontAnimate()
                    .into(binding!!.imageViewUser)
            }

            binding!!.tvIdType.setOnClickListener(null)
            //    binding!!.editTextCardNumber.isEnabled = !binding!!.editTextCardNumber.text.isEmpty()

            binding!!.frameNewInfo.setBackgroundResource(R.drawable.bg_info_unselected)
            binding!!.frameCurrentInfo.setBackgroundResource(0)
        } else {
            binding!!.radioButtonNewId.setTextColor(
                ContextCompat.getColor(
                    context,
                    R.color.colorPrimary
                )
            )
            binding!!.radioButtonCurrentInfo.setTextColor(
                ContextCompat.getColor(
                    context, R.color.colorGray
                )
            )
            binding!!.tvIdType.text = ""
            //    binding!!.editTextCardNumber.setText("")
            binding!!.imageViewUser.visibility = View.GONE

            binding!!.tvIdType.setOnClickListener(this)
            //     binding!!.editTextCardNumber.isEnabled = false
            binding!!.editTextName.setText("")
            binding!!.tvDate.text = ""
            binding!!.tvMonth.text = ""
            binding!!.tvYear.text = ""
            binding!!.tvSex.text = ""

            binding!!.frameCurrentInfo.setBackgroundResource(R.drawable.bg_info_unselected)
            binding!!.frameNewInfo.setBackgroundResource(0)
        }
    }

    private fun disableEdit(isDisable: Boolean) {
        binding!!.editTextCardNumber.isEnabled = !isDisable
        binding!!.editTextName.isEnabled = !isDisable
        binding!!.tvSex.isEnabled = !isDisable
        binding!!.tvDate.isEnabled = !isDisable
        binding!!.tvMonth.isEnabled = !isDisable
        binding!!.tvYear.isEnabled = !isDisable
        binding!!.layoutUploadFront.isEnabled = !isDisable
    }

    private fun clearLayout() {
        //ctv_doc_type.text = ""

        binding!!.editTextCardNumber.setText("")
        binding!!.editTextName.setText("")
        binding!!.tvSex.text = ""
        binding!!.tvDate.text = ""
        binding!!.tvMonth.text = ""
        binding!!.tvYear.text = ""

        binding!!.imageViewFront.visibility = View.GONE
        mOutputFileFront = null
        //   textView_font_id.text = "Front ID / Passport"
        //   text_view_upload.text = "Upload"


        binding!!.imageViewBack.visibility = View.GONE
        mOutputFileBack = null
        // text_view_back.text = "Back ID / Passport"
        // text_view_back_upload = "hellow"
        //text_view_back_upload = "Upload"

        binding!!.imageViewUser.visibility = View.GONE
        mOutputFileUser = null
        // text_view_photo = "Photo"
        // text_view_upload_photo = "Upload"

    }

    fun onScanIdCardResult(data: Intent) {

        val fullName =
            data.getStringExtra(Constant.MRZ_FIRST_NAME) + " " + data.getStringExtra(Constant.MRZ_LAST_NAME)
        binding!!.editTextName.setText(fullName)

//        //Date Of birth profile
        val dateOfBirthMRZ = data.getStringExtra(Constant.MRZ_DOB)?.split(" ")
        if (dateOfBirthMRZ?.size!! > 5) {
            val newDate = SimpleDateFormat(
                "dd MMM yyyy", Locale.US
            ).parse("${dateOfBirthMRZ[2]} ${dateOfBirthMRZ[1]} ${dateOfBirthMRZ[5]}")
            calendar.time = newDate
            dateOfBirth = SimpleDateFormat("yyyy-MM-dd", Locale.US).format(calendar.time)
            ProfileSharedPreference.getInstance(context)?.setDob(dateOfBirth)

            try {
                binding!!.tvDate.text = "${dateOfBirthMRZ[2]}"
                ProfileSharedPreference.getInstance(context)?.setDay(dateOfBirthMRZ[2])
                binding!!.tvMonth.text = "${dateOfBirthMRZ[1]}"
                ProfileSharedPreference.getInstance(context)?.setMonth(dateOfBirthMRZ[1])
                binding!!.tvYear.text = "${dateOfBirthMRZ[5]}"
                ProfileSharedPreference.getInstance(context)?.setYear(dateOfBirthMRZ[5])
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        if (data.getStringExtra(Constant.MRZ_GENDER) == "M") {
            binding!!.tvSex.text = "Male"
            mGenderKeyPost = "male"
        } else {
            binding!!.tvSex.text = "Female"
            mGenderKeyPost = "female"
        }

        val dateExpiry = data.getStringExtra(Constant.MRZ_DATE_OF_EXPIRY_TYPE) ?: ""
        dateOfExpiry = formatExpiryDate(dateExpiry)
        nationality = data.getStringExtra(Constant.MRZ_COUNTRY_CODE) ?: ""

        ProfileSharedPreference.getInstance(context)?.setGender(mGenderKeyPost)

        getIdType(data.getStringExtra(Constant.MRZ_DOCUMENT_TYPE).toString())
        binding!!.editTextCardNumber.setText(data.getStringExtra(Constant.MRZ_ID))
    }

    private fun formatExpiryDate(expiry: String): String {
        return try {
            val inputFormat = SimpleDateFormat("yyMMdd", Locale.getDefault())
            val outputFormat = SimpleDateFormat("dd-MM-yy", Locale.getDefault())
            val date = inputFormat.parse(expiry)
            outputFormat.format(date ?: return "Invalid date")
        } catch (e: Exception) {
            "Invalid date"
        }
    }

    fun getIdType(typeIDScan: String = "") {
        if (certificateModel.size == 0) object : SeatelJSONArrayRequest(context) {

            override fun getFunctionName(): String {
                return "certifications"
            }

        }.execute { itf ->
            certificateModel = ArrayList()
            val certificateObject = itf as JSONArray
            for (i in 0 until certificateObject.length()) {
                val scannable = certificateObject.optJSONObject(i).optBoolean("scannable")
                if (scannable) {
                    disableEdit(scannable)
                } else disableEdit(false)
                certificateModel.add(
                    BottomChooserDialog.BottomChooserModel(
                        certificateObject.optJSONObject(i).optInt("certId"),
                        certificateObject.optJSONObject(i).optString("certName")
                    )
                )
            }
            if (typeIDScan.isNotEmpty()) {

                if (typeIDScan == "ID") {
                    certificateModel.filter { it.name == "ID Card" }
                        .forEach { updatedDocTypeSelected(it) }
                } else {
                    certificateModel.filter { it.name == "Passport" }
                        .forEach { updatedDocTypeSelected(it) }
                }


            } else {
                showChooserDialog(certificateModel, object : BottomChooserDialog.OnItemChooser {
                    override fun onChose(
                        position: Int, data: BottomChooserDialog.BottomChooserModel
                    ) {
                        mIdType = data.name
                        binding!!.tvIdType.text = data.name
                        mCertificationNamePost = data.name
                        idCertificationType = data.id
                        binding!!.editTextCardNumber.isEnabled = true
                        ProfileSharedPreference.getInstance(context)?.setDocumentType(data.name)
                    }
                })
            }
        }
        else if (typeIDScan.isNotEmpty()) {
            if (typeIDScan == "ID") {
                certificateModel.filter { it.name == "ID Card" }
                    .forEach { updatedDocTypeSelected(it) }
            } else {
                certificateModel.filter { it.name == "Passport" }
                    .forEach { updatedDocTypeSelected(it) }
            }
        } else {
            showChooserDialog(certificateModel, object : BottomChooserDialog.OnItemChooser {
                override fun onChose(
                    position: Int, data: BottomChooserDialog.BottomChooserModel
                ) {
                    mIdType = data.name
                    binding!!.tvIdType.text = data.name
                    mCertificationNamePost = data.name
                    idCertificationType = data.id
                    binding!!.editTextCardNumber.isEnabled = true
                    ProfileSharedPreference.getInstance(context)?.setDocumentType(data.name)
                }
            })
        }
    }

    private fun showChooserDialog(
        bottomChooserModel: ArrayList<BottomChooserDialog.BottomChooserModel>,
        onItemChooser: BottomChooserDialog.OnItemChooser
    ) {
        BottomChooserDialog(context).addItems(bottomChooserModel, onItemChooser).show()
    }

    private fun showChooserDialog(
        bottomChooserModel: ArrayList<BottomChooserDialog.BottomChooserModel>, textView: TextView
    ) {
        BottomChooserDialog(context).addItems(
            bottomChooserModel,
            object : BottomChooserDialog.OnItemChooser {
                override fun onChose(position: Int, data: BottomChooserDialog.BottomChooserModel) {
                    textView.text = data.name
                    mGenderKeyPost = data.name
                    ProfileSharedPreference.getInstance(context)?.setGender(data.name)
                }
            }).show()
    }

    fun setImageCrop(bitmap: Bitmap?) {

        when (imageType) {
            "front" -> {
                binding!!.imageViewFront.visibility = View.VISIBLE
                binding!!.imageViewFront.setImageBitmap(bitmap)
            }

            "back" -> {
                binding!!.imageViewBack.visibility = View.VISIBLE
                binding!!.imageViewBack.setImageBitmap(bitmap)
            }

            else -> {
                binding!!.imageViewUser.visibility = View.VISIBLE
                binding!!.imageViewUser.setImageBitmap(bitmap)
            }
        }
    }
}