package com.seatel.mobilehall.util

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import coil.load
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.lang.LanguageManager

class CustomGameDialog(
    context: Context,
    title: String,
    prize: String,
    subtitle: String,
    image: String,
    isDoneShow: Boolean
) : Dialog(context) {

    private var isDimissClose = false

    init {
        initValentine(title, prize, subtitle, image, isDoneShow)
    }

    fun isDimissClose(): Boolean {
        return isDimissClose
    }

    private fun initValentine(
        title: String,
        prize: String,
        subtitle: String,
        image: String,
        isDoneShow: Boolean
    ) {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.dialog_mystery)
        setCancelable(false)
        if (window != null) {
            window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT
            )
            window!!.attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            window!!.setDimAmount(0.5f)
            window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        }

        val mTitle = findViewById<TextView>(R.id.tv_congratulation)
        val mPrize = findViewById<ImageView>(R.id.iv_data)
       // val mSubTitle = findViewById<TextView>(R.id.valentine_subTitle)
      //  val btnDone = findViewById<Button>(R.id.btn_done)
      /*  btnDone.text = LanguageManager(context).translateWords(
            context, context.resources.getString(R.string.done)
        )*/
        mTitle.text = title
        /* if (prize.isEmpty()) {
             mPrize.visibility = View.GONE
         } else*/
        if (image.isNotBlank())
            mPrize.load(image) { crossfade(true) }
        else
            mPrize.visibility = View.GONE

       /* if (subtitle.isNotBlank())
            mSubTitle.text = subtitle
        else
            mSubTitle.visibility = View.GONE

        if (isDoneShow)
            btnDone.visibility = View.VISIBLE

        btnDone.setOnClickListener {
            dismiss()
        }*/
        val close = findViewById<ImageView>(R.id.valentine_close)
        close.setOnClickListener {
            dismiss()

        }
    }

}