package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.yes_member.interactor.RedeemCodeInteractor
import org.json.JSONObject

class RedeemCodePresenter(var context: Context, private val view: RedeemCodeInteractor.View) :
    RedeemCodeInteractor.Presenter {


    override fun onRedeemCode(type: String, data: String, phoneNumber: String) {
        requestRedeemCode(type, data, phoneNumber).setOnErrorListener {
            view.onRedeemCodeFailure(it)

        }.setOnResponseListener {
            view.onRedeemCodeSuccess(it as JSONObject)
        }.execute()
    }


    private fun requestRedeemCode(
        type: String, data: String, phoneNumber: String
    ): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(context) {
            override fun getFunctionName(): String {
                return "yes-member/member/redeem-discount"
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

            override fun onGetBodyRequest(): String {
                val jsonObject = JSONObject()
                jsonObject.put("type", type)
                jsonObject.put("data", data)
                jsonObject.put("phoneNumber", phoneNumber)
                return jsonObject.toString()
            }

        }

    }
}