package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import coil.load
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityPartnerSearchCategoryDetailBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.PartnerSearchCategoryDetailAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.PartnerCategoryByNameInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerByNameModel
import com.seatel.mobilehall.ui.yes_member.presenter.PartnerCategoryByNamePresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class PartnerSearchCategoryDetailActivity :
    BaseActivity<ActivityPartnerSearchCategoryDetailBinding>(),
    PartnerCategoryByNameInteractor.View {

    companion object {
        fun launch(context: Context, name: String) {
            val intent = Intent(context, PartnerSearchCategoryDetailActivity::class.java)
            intent.putExtra("name", name)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityPartnerSearchCategoryDetailBinding {
        return ActivityPartnerSearchCategoryDetailBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

        PartnerCategoryByNamePresenter(
            this,
            this
        ).onPartnerCategoryByName(intent.getStringExtra("name")!!)

    }


    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun responsePartnerCategoryByNameSucceed(topPartnerList: ArrayList<PartnerByNameModel>) {

        for (topPartner in topPartnerList) {
            binding.ivHeaderBanner.load(topPartner.banner)
            binding.tvCategoryName.text = topPartner.category
            binding.tvName.text = topPartner.name
            binding.tvCategoryDescription.text = topPartner.description

            binding.recyclerOutlet.adapter =
                PartnerSearchCategoryDetailAdapter(this, topPartner.outlet)

        }

    }

    override fun responsePartnerCategoryByNameFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }
}