package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.recyclerview.widget.GridLayoutManager
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityPartnerSearchBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.MainPartnerCategoryAdapter
import com.seatel.mobilehall.ui.yes_member.adapter.TopPartnerSearchAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.PartnerSearchInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerCategoryModelItem
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem
import com.seatel.mobilehall.ui.yes_member.presenter.PartnerSearchPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class PartnerSearchActivity : BaseActivity<ActivityPartnerSearchBinding>(),
    PartnerSearchInteractor.View {


    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, PartnerSearchActivity::class.java)
            context.startActivity(intent)
        }

    }


    override fun getViewBinding(): ActivityPartnerSearchBinding {
        return ActivityPartnerSearchBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }
        binding.tvCancel.setOnClickListener {
            binding.btnSearch.text?.clear()
        }
        PartnerSearchPresenter(this, this).onTopPartner()
        PartnerSearchPresenter(this, this).onPartnerCategory()
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    override fun onTopPartnerSucceed(partnerSearchList: ArrayList<PartnerModelItem>) {
        binding.recyclerPartner.adapter = TopPartnerSearchAdapter(this, partnerSearchList)
    }

    override fun onTopPartnerFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun responsePartnerCategorySucceed(partnerCategory: ArrayList<PartnerCategoryModelItem>) {
        binding.recyclerCategoryPartner.layoutManager = GridLayoutManager(this, 2)
        binding.recyclerCategoryPartner.adapter = MainPartnerCategoryAdapter(this, partnerCategory)
    }

    override fun responsePartnerCategoryFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }


}