package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import coil.load
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityPartnerBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.PartnerAdapter
import com.seatel.mobilehall.ui.yes_member.adapter.PartnerCategoryListAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.TopPartnerInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem
import com.seatel.mobilehall.ui.yes_member.presenter.TopPartnerPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class PartnerActivity : BaseActivity<ActivityPartnerBinding>(), TopPartnerInteractor.View {

    companion object {
        fun launch(context: Context, imgBanner: String) {
            val intent = Intent(context, PartnerActivity::class.java)
            intent.putExtra("imgBanner", imgBanner)
            context.startActivity(intent)
        }
    }

    private lateinit var adapter: PartnerAdapter

    override fun getViewBinding(): ActivityPartnerBinding {
        return ActivityPartnerBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()

        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

        binding.ivPartnerBanner.load(intent.getStringExtra("imgBanner")) {
            crossfade(true)
        }

        TopPartnerPresenter(this, this).onTopPartner()

        binding.btnSearch.setOnClickListener {
            PartnerSearchActivity.launch(this)
        }

    }


    override fun responseTopPartnerSucceed(topPartnerList: ArrayList<PartnerModelItem>) {

        binding.recyclerTopPartner.layoutManager =
            LinearLayoutManager(this, LinearLayoutManager.HORIZONTAL, false)
        adapter = PartnerAdapter(this, topPartnerList)
        binding.recyclerTopPartner.adapter = adapter


        binding.recyclerPartner.adapter = PartnerCategoryListAdapter(this, topPartnerList)
    }

    override fun responseTopPartnerFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }
}