package com.seatel.mobilehall.ui.profile.activity;

import android.os.Bundle;
import android.view.MenuItem;
import android.view.WindowManager;

import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.profile.model.ScanModuleEnum;

import java.io.File;
import java.io.IOException;

import at.nineyards.anyline.models.AnylineImage;


abstract public class ScanActivity extends ScanningConfigurationActivity {
    /**
     * @return the module type view {@link ScanModuleEnum scanModule}
     */
    protected abstract ScanModuleEnum.ScanModule getScanModule();

    protected long timeStarted;
    //  protected boolean hasScannedOneTime = false;
    //   private boolean feedbackViewActive;
    //  private FeedbackView feedbackView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_scan);

      /*  Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
*/
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        //Set the flag to keep the screen on (otherwise the screen may go dark during scanning)
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

    }

    @Override
    protected void onResume() {
        super.onResume();
        resetTime();

    }

    /**
     * resets the time used the calculate how many seconds the scan required from startScanning() until a result has been reported
     */
    protected void resetTime() {
        timeStarted = System.currentTimeMillis();
    }

 /*   protected long milliSecondsPassedSinceStartedScanning() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - timeStarted);

    }*/

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        overridePendingTransition(R.anim.fade_in, R.anim.activity_close_translate);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        if (item.getItemId() == android.R.id.home) {
            finish();
            overridePendingTransition(R.anim.fade_in, R.anim.activity_close_translate);
            return true;
        }

        return super.onOptionsItemSelected(item);
    }


    @Override
    protected void onPause() {
        super.onPause();

    }


    protected String setupImagePath(AnylineImage image) {
        String imagePath = "";
        long time = System.currentTimeMillis();
        try {
            if (this.getExternalFilesDir(null) != null) {

                imagePath = this
                        .getExternalFilesDir(null)
                        .toString() + "/results/" + "mrz_image" + time;

            } else if (this.getFilesDir() != null) {

                imagePath = this
                        .getFilesDir()
                        .toString() + "/results/" + "mrz_image" + time;

            }
            File fullFile = new File(imagePath);
            //create the directory
            fullFile.mkdirs();
            image.save(fullFile, 100);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return imagePath;
    }
}

