package com.seatel.mobilehall.ui.profile.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.View
import android.view.View.SCROLL_AXIS_HORIZONTAL
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityChangePasswordBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.profile.interactor.NewPasswordInteractor
import com.seatel.mobilehall.ui.profile.presenter.NewPasswordPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView

class ChangePasswordActivity : BaseActivity<ActivityChangePasswordBinding>(),
    NewPasswordInteractor.View {
    private lateinit var mNewPasswordPresenter: NewPasswordPresenter
    private lateinit var mNewPasswordInteractor: NewPasswordInteractor.View

    private var mCurrentPassword = ""
    private var mNewPassword = ""
    private var mConfirmNewPassword = ""
    private var mPhoneNumber = ""

    override fun onNewPassSucceed() {
        ChangePasswordCompletedActivity.lunch(this)
        binding.errorView.visibility = View.GONE
        finish()
    }

    override fun onNewPassFailed(error: VolleyError) {
        binding.errorView.visibility = View.GONE
        SeatelUtils.showErrorDialog(this, SeatelSuperRequest.getErrorMessageFrom(error))
    }

    override fun getViewBinding(): ActivityChangePasswordBinding {
        return ActivityChangePasswordBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterUpAnimation()
        setContentView(R.layout.activity_change_password)
        binding.imageViewClose.setOnClickListener { onBackPressed() }
        mPhoneNumber = getMainPhoneLogin()
        mNewPasswordInteractor = this
        mNewPasswordPresenter = NewPasswordPresenter(this, mNewPasswordInteractor)
        binding.buttonYes.setOnClickListener {
            SeatelUtils.hideKeyboard(this)
            if (checkValidate()) {
                binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
                mNewPasswordPresenter.onSetNewPassword(mPhoneNumber, mCurrentPassword, mNewPassword)
            }
        }
        binding.ctvCurrentPassword.hint = binding.ctvCurrentPassword.hint
        binding.ctvNewPassword.hint = binding.ctvNewPassword.hint
        binding.ctvConfirmNewPassword.hint = binding.ctvConfirmNewPassword.hint

        binding.layoutMain.setOnClickListener {
            SeatelUtils.hideKeyboard(this)
        }
        initParallaxView()
    }

    private fun checkValidate(): Boolean {
        mCurrentPassword = binding.ctvCurrentPassword.text.toString().trim()
        mNewPassword = binding.ctvNewPassword.text.toString().trim()
        mConfirmNewPassword = binding.ctvConfirmNewPassword.text.toString().trim()

        var msg = ""

        if (mCurrentPassword.isEmpty())
            msg = getString(R.string.current_password_empty)
        else if (mNewPassword.isEmpty())
            msg = getString(R.string.new_password_empty)
        else if (mConfirmNewPassword.isEmpty())
            msg = getString(R.string.confirm_new_password_empty)
        else if (!TextUtils.equals(mNewPassword, mConfirmNewPassword))
            msg = getString(R.string.confirm_new_password_not_match)
        else if (mCurrentPassword.length < 6)
            msg = getString(R.string.current_password_at_least_6_digit)
        else if (mNewPassword.length < 6)
            msg = getString(R.string.password_at_least_6_digit)

        if (!TextUtils.isEmpty(msg)) {
            SeatelAlertDialog.with(this, msg).show()
            return false
        }
        return true
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitDownAnimation()
    }

    private fun initParallaxView() {
        binding.activityHome.parallaxViewSkyLine.setActualImageResource(R.drawable.sky_line_bg)
        binding.activityHome.parallaxViewSkyLine.canScrollHorizontally(SCROLL_AXIS_HORIZONTAL)
        binding.activityHome.parallaxViewSkyLine.visibility = View.VISIBLE

//        binding.activityHome.parallaxViewSkyLine.viewTreeObserver.add

        Handler().postDelayed({
            binding.activityHome.parallaxViewSkyLine.setOffset(0.5f)
            scrollBackgroundY(true)

        }, 200)

    }

    private fun scrollBackgroundY(isScrollUp: Boolean) {

//        val displayMetrics = DisplayMetrics()
//        this.windowManager.defaultDisplay.getMetrics(displayMetrics)

        val targetPos = (SeatelUtils.getDisplayMetrics(this).heightPixels / 2 -
                (binding.activityHome.parallaxViewSkyLine.height / 2 + SeatelUtils.convertDpToPx(
                    this,
                    10
                )))
        if (isScrollUp) translateY(-targetPos.toFloat())
        else translateY(0f)

    }

    private fun translateY(targetPos: Float) {
        binding.activityHome.parallaxViewSkyLine.visibility = View.VISIBLE
        binding.activityHome.parallaxViewSkyLine.animate().translationY(targetPos).duration = 200
        binding.activityHome.view.animate().translationY(targetPos).duration = 200
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, ChangePasswordActivity::class.java)
            context.startActivity(intent)
        }
    }
}


