package com.seatel.mobilehall.ui.login.presenter

import android.content.Context
import android.text.TextUtils
import android.util.Log
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.login.interactor.SignUpInteractor
import com.seatel.mobilehall.ui.login.model.ResetPasswordModel
import org.json.JSONException
import org.json.JSONObject

class ResetPasswordPresenter(
    private var mContext: Context,
    private var mSingUpView: SignUpInteractor.View? = null
) : SignUpInteractor.Presenter {

    private var requestSignup: SeatelJSONObjectRequest? = null

    override fun onRequestCode(
        phoneNumber: String,
        email: String,
        type: String,
        version: String,
        newPhoneNumber: String
    ) {
        getSignUpRequest(
            phoneNumber,
            email,
            type,
            version,
            newPhoneNumber
        ).setOnErrorListener { error ->
            mSingUpView?.onRequestCodeFailed(error)
        }.setOnResponseListener { response ->
            mSingUpView?.onRequestCodeSucceed(getData(response as JSONObject))
        }.execute()
    }

    private fun getData(jsonObject: JSONObject): ResetPasswordModel {
        val gson = Gson()
        return gson.fromJson(jsonObject.toString(), ResetPasswordModel::class.java)
    }

    fun onDestroy() {
        mSingUpView = null
    }

    private fun getSignUpRequest(
        phoneNumber: String,
        email: String,
        type: String,
        version: String,
        newPhoneNumber: String
    ): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {
            override fun getFunctionName(): String {
                return "v2/seatel/request-code"
            }

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("phoneNumber", phoneNumber)
                    data.put("type", type)
                    if (!TextUtils.isEmpty(email))
                        data.put("email", email)
                    if (newPhoneNumber.isNotEmpty())
                        data.put("newPhoneNumber", newPhoneNumber)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }
                Log.d("checkResetPassword", data.toString())
                return data.toString()
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }


        }


        /*  override fun getAppSignatures(): String {
              val appSign = AppSignatureHelper(mContext).getAppSignatures()
              return if (appSign.size > 0) appSign[0] else ""
          }*/


    }
    //    return requestSignup!!
}