package com.seatel.mobilehall.data.network;

import android.content.Context;
import android.text.TextUtils;

import com.android.volley.AuthFailureError;
import com.android.volley.VolleyError;
import com.seatel.mobilehall.BuildConfig;
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences;
import com.seatel.mobilehall.util.Constant;
import com.seatel.mobilehall.util.lang.LanguageManager;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Danny on 12/29/2017.
 */

public abstract class SeatelRequest<T> extends SeatelSuperRequest<T> {

    SeatelRequest(Context context) {
        super(context);
    }

    @Override
    public Map<String, String> getAuthHeader() {
        Map<String, String> stringStringMap = new HashMap<>();

        String token = SeatelSharePreferences.Companion.getInstance(getContext()).getAccessToken();
        if (!token.isEmpty())
            stringStringMap.put("User ", SeatelSharePreferences.Companion.getInstance(getContext()).getAccessToken());
        else stringStringMap.put("x-api-key", BuildConfig.CLIENT_ID);

        return stringStringMap;
    }

    @Override
    public String getBaseController() {
        return Constant.BASE_CONTROLLER;
    }

    @Override
    public String getLanguageCode() {
        String languageCode = LanguageManager.Companion.getInstance(getContext()).getLanguageCode();
        if (TextUtils.equals(languageCode.toLowerCase(), "kh")) {
            return "KM";
        } else if (TextUtils.equals(languageCode.toLowerCase(), "ch")) {
            return "ZH";
        } else {
            return languageCode;
        }
    }

    @Override
    public String getBaseUrl() {
        return BuildConfig.BASE_URL + getBaseController() + ((getFunctionName() != null) ? getFunctionName() : "");
    }

    @Override
    public void onError(VolleyError error) {
        if (error instanceof AuthFailureError) {
            if (error.networkResponse.statusCode == 401) {
//                SeatelUtils.showSessionExpired(getContext());
            }
        } else {
            super.onError(error);
        }
    }
}
